/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.filter;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.DataTypeArray;
import gr.uoa.di.madgik.execution.datatype.DataTypeReflectable;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import gr.uoa.di.madgik.execution.utils.ReflectableAnalyzer;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterReflectableToTemplateFilter
extends ParameterFilterBase {
    private static Logger logger = LoggerFactory.getLogger(ParameterReflectableToTemplateFilter.class);
    public boolean StoreOutput = false;
    public String StoreOutputVariableName = null;
    public String FilteredVariableName = null;
    public String TemplateVariableName = null;

    @Override
    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.FilteredVariableName);
        vars.add(this.TemplateVariableName);
        return vars;
    }

    @Override
    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.StoreOutputVariableName);
        return vars;
    }

    @Override
    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.FilteredVariableName == null || this.FilteredVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Expected parameter name not provided");
        }
        if (this.TemplateVariableName == null || this.TemplateVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Expected parameter name not provided");
        }
        if (this.StoreOutput && (this.StoreOutputVariableName == null || this.StoreOutputVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("No output variable name defined to store output");
        }
        this.TokenMappingValidate();
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (!Handle.GetPlan().Variables.Contains(this.TemplateVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        ndt = Handle.GetPlan().Variables.Get(this.TemplateVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.TemplateVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (this.StoreOutput) {
            for (String storeVarName : this.GetStoreOutputVariableName()) {
                if (Handle.GetPlan().Variables.Contains(storeVarName)) continue;
                throw new ExecutionValidationException("Needed parameter to store output not present");
            }
        }
    }

    @Override
    public boolean SupportsOnLineFiltering() {
        return false;
    }

    @Override
    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    @Override
    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    @Override
    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
            NamedDataType ndtx = Handle.GetPlan().Variables.Get(this.TemplateVariableName);
            if (!(ndt.Value instanceof DataTypeReflectable || ndt.Value instanceof DataTypeArray && DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(((DataTypeArray)ndt.Value).GetArrayClassCode()).equals((Object)IDataType.DataTypes.Reflectable))) {
                throw new ExecutionValidationException("The filter can only be applied on reflectable input filtered variable or arrays of them");
            }
            String template = ndtx.Value.GetStringValue();
            logger.debug("template string is " + template);
            logger.debug("Value variable is ");
            if (ndt.Value instanceof DataTypeArray) {
                StringBuilder buf = new StringBuilder();
                for (IDataType dt : (DataTypeArray)ndt.Value) {
                    if (!(dt instanceof DataTypeReflectable)) {
                        throw new ExecutionValidationException("The array element is not of required type");
                    }
                    ReflectableAnalyzer anal = new ReflectableAnalyzer();
                    String reflString = anal.PopulateTemplateFromReflectable(template, (DataTypeReflectable)dt, this.TokenMapping);
                    buf.append(reflString);
                }
                String reflString = buf.toString();
                logger.debug("Populated string is " + reflString);
                return reflString;
            }
            if (ndt.Value instanceof DataTypeReflectable) {
                ReflectableAnalyzer anal = new ReflectableAnalyzer();
                String reflString = anal.PopulateTemplateFromReflectable(template, (DataTypeReflectable)ndt.Value, this.TokenMapping);
                logger.debug("Populated string is " + reflString);
                return reflString;
            }
            throw new ExecutionValidationException("The filter can only be applied on reflectable input filtered variable or arrays of them");
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not extract value", ex);
        }
    }

    @Override
    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!(XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"order").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!ParameterFilterBase.FilterType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"type")).equals((Object)this.GetFilterType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"order"));
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.StoreOutputVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if ((tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable")) == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.FilteredVariableName = XMLUtils.GetChildText((Node)tmp);
            tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"templateVariable");
            if (tmp == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.TemplateVariableName = XMLUtils.GetChildText((Node)tmp);
            this.TokenMappingFromXML(XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        String outputvarString = "";
        if (this.StoreOutputVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.StoreOutputVariableName + "\"";
        }
        buf.append("<filter type=\"" + this.GetFilterType().toString() + "\" order=\"" + this.GetOrder() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + ">");
        if (this.FilteredVariableName == null) {
            buf.append("<filteredVariable/>");
        } else {
            buf.append("<filteredVariable>" + this.FilteredVariableName + "</filteredVariable>");
        }
        if (this.TemplateVariableName == null) {
            buf.append("<templateVariable/>");
        } else {
            buf.append("<templateVariable>" + this.TemplateVariableName + "</templateVariable>");
        }
        buf.append(this.TokenMappingToXML());
        buf.append("</filter>");
        return buf.toString();
    }

    @Override
    public ParameterFilterBase.FilterType GetFilterType() {
        return ParameterFilterBase.FilterType.ReflectableToTemplate;
    }
}

