/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.datatype;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTypeLongPrimitive
implements IDataType {
    private long Value;

    @Override
    public boolean CanSuggestDataTypeClass() {
        return true;
    }

    @Override
    public Class<?> GetDataTypeClass() {
        return Long.TYPE;
    }

    @Override
    public IDataType.DataTypes GetDataTypeEnum() {
        return IDataType.DataTypes.LongPrimitive;
    }

    @Override
    public String GetStringValue() throws ExecutionSerializationException {
        return Long.toString(this.Value);
    }

    @Override
    public Object GetValue() {
        return this.Value;
    }

    @Override
    public void SetStringValue(String val) throws ExecutionValidationException, ExecutionSerializationException {
        if (val == null || val.trim().length() == 0) {
            throw new ExecutionValidationException("Cannot set primitive type with null value");
        }
        this.SetValue(val);
    }

    @Override
    public void SetValue(Object Value) throws ExecutionValidationException {
        if (Value == null) {
            throw new ExecutionValidationException("Cannot set primitive type with null value");
        }
        this.Value = DataTypeUtils.GetValueAsLong(Value);
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)XML, (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!IDataType.DataTypes.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetDataTypeEnum())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            Element valelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"value");
            if (valelem == null) {
                throw new ExecutionSerializationException("Cannot set null value in specific data type");
            }
            this.SetValue(XMLUtils.GetChildText((Node)valelem));
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<dt type=\"" + this.GetDataTypeEnum().toString() + "\">");
        buf.append("<value>");
        buf.append(this.Value);
        buf.append("</value>");
        buf.append("</dt>");
        return buf.toString();
    }
}

