/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.event;

import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;

public class ExecutionPerformanceReportStateEvent
extends ExecutionStateEvent {
    private long EmitTimestamp = Calendar.getInstance().getTimeInMillis();
    private String ID = "";
    private long TotalTime = 0L;
    private long InitializationTime = 0L;
    private long FinilizationTime = 0L;
    private long ChildrenTotalTime = 0L;
    private int SubCalls = 0;
    private long CallTotalTime = 0L;

    public ExecutionPerformanceReportStateEvent() {
    }

    public ExecutionPerformanceReportStateEvent(String ID) {
        this.ID = ID;
    }

    public ExecutionPerformanceReportStateEvent(String ID, long TotalTime, long InitializationTime, long FinilizationTime, long ChildrenTotalTime, int SubCalls, long CallTotalTime) {
        this.ID = ID;
        this.TotalTime = TotalTime;
        this.InitializationTime = InitializationTime;
        this.FinilizationTime = FinilizationTime;
        this.ChildrenTotalTime = ChildrenTotalTime;
        this.SubCalls = SubCalls;
        this.CallTotalTime = CallTotalTime;
    }

    public String GetID() {
        return this.ID;
    }

    public long GetTotalTime() {
        return this.TotalTime;
    }

    public void SetTotalTime(long TotalTime) {
        this.TotalTime = TotalTime;
    }

    public long GetInitializationTime() {
        return this.InitializationTime;
    }

    public void SetInitializationTime(long InitializationTime) {
        this.InitializationTime = InitializationTime;
    }

    public long GetFinilizationTime() {
        return this.FinilizationTime;
    }

    public void SetFinilizationTime(long FinilizationTime) {
        this.FinilizationTime = FinilizationTime;
    }

    public long GetChildrenTotalTime() {
        return this.ChildrenTotalTime;
    }

    public void SetChildrenTotalTime(long ChildrenTotalTime) {
        this.ChildrenTotalTime = ChildrenTotalTime;
    }

    public long GetSubCallTotalTime() {
        return this.CallTotalTime;
    }

    public void SetSubCallTotalTime(long CallTotalTime) {
        this.CallTotalTime = CallTotalTime;
    }

    public int GetSubCalls() {
        return this.SubCalls;
    }

    public void SetSubCalls(int SubCalls) {
        this.SubCalls = SubCalls;
    }

    @Override
    public ExecutionStateEvent.EventName GetEventName() {
        return ExecutionStateEvent.EventName.ExecutionPerformance;
    }

    @Override
    public long GetEmitTimestamp() {
        return this.EmitTimestamp;
    }

    @Override
    public void Decode(byte[] buf) throws ExecutionSerializationException {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(buf);
            DataInputStream din = new DataInputStream(bin);
            this.EmitTimestamp = din.readLong();
            this.ID = din.readUTF();
            this.TotalTime = din.readLong();
            this.InitializationTime = din.readLong();
            this.FinilizationTime = din.readLong();
            this.ChildrenTotalTime = din.readLong();
            this.SubCalls = din.readInt();
            this.CallTotalTime = din.readLong();
            din.close();
            bin.close();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not serialize event", ex);
        }
    }

    @Override
    public byte[] Encode() throws ExecutionSerializationException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeLong(this.EmitTimestamp);
            dout.writeUTF(this.ID == null ? "" : this.ID);
            dout.writeLong(this.TotalTime);
            dout.writeLong(this.InitializationTime);
            dout.writeLong(this.FinilizationTime);
            dout.writeLong(this.ChildrenTotalTime);
            dout.writeInt(this.SubCalls);
            dout.writeLong(this.CallTotalTime);
            dout.flush();
            dout.close();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not serialize event", ex);
        }
    }
}

