/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.engine;

import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.execution.engine.EngineStatus;
import gr.uoa.di.madgik.execution.engine.ExecutionEngineConfig;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.engine.PlanExecutor;
import gr.uoa.di.madgik.execution.exception.ExecutionEngineFullException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.ExecutionPlan;
import gr.uoa.di.madgik.is.InformationSystem;
import java.util.ArrayList;
import java.util.List;

public class ExecutionEngine {
    private static ExecutionEngine Engine = null;
    private static final Object lockMe = new Object();
    private ExecutionEngineConfig Config;
    private List<PlanExecutor> Executors = new ArrayList<PlanExecutor>();
    public static final String PRODUCERID = "ExecutionEngine";
    public static final String LOADTOPICNAME = "NodeLoadMonitoring";
    private static String localhost = null;

    public static String getLocalhost(EnvHintCollection envHints) {
        if (localhost == null) {
            try {
                localhost = InformationSystem.GetLocalNodeHostName();
                localhost = localhost + ":";
                localhost = localhost + InformationSystem.GetLocalNodePE2ngPort((EnvHintCollection)envHints);
            }
            catch (EnvironmentInformationSystemException e) {
                localhost = null;
            }
        }
        return localhost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Init(ExecutionEngineConfig Config) {
        Object object = lockMe;
        synchronized (object) {
            if (Engine == null) {
                Engine = new ExecutionEngine(Config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionHandle Submit(ExecutionPlan plan) throws ExecutionEngineFullException, ExecutionValidationException, ExecutionInternalErrorException {
        Object object = lockMe;
        synchronized (object) {
            if (Engine == null) {
                throw new ExecutionInternalErrorException("Execution engine has not been initialized");
            }
            return Engine.SubmitPlan(plan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Execute(ExecutionHandle Handle) throws ExecutionInternalErrorException {
        Object object = lockMe;
        synchronized (object) {
            if (Engine == null) {
                throw new ExecutionInternalErrorException("Execution engine has not been initialized");
            }
            Engine.ExecutePlan(Handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineStatus GetEngineStatus() throws ExecutionInternalErrorException {
        Object object = lockMe;
        synchronized (object) {
            if (Engine == null) {
                throw new ExecutionInternalErrorException("Execution engine has not been initialized");
            }
            return Engine.EngineStatus();
        }
    }

    private ExecutionEngine(ExecutionEngineConfig Config) {
        this.Config = Config;
    }

    private ExecutionHandle SubmitPlan(ExecutionPlan plan) throws ExecutionEngineFullException, ExecutionValidationException {
        plan.Validate();
        if (!this.CanAcceptNewPlan()) {
            throw new ExecutionEngineFullException("Reached maximum number of executing plans");
        }
        ExecutionHandle Handle = new ExecutionHandle(plan, ExecutionEngine.getLocalhost(plan.EnvHints));
        return Handle;
    }

    private void ExecutePlan(ExecutionHandle Handle) {
        PlanExecutor ex = new PlanExecutor(Handle);
        this.Executors.add(ex);
        ex.start();
    }

    private boolean CanAcceptNewPlan() {
        int numberofplans = 0;
        numberofplans = this.Executors.size();
        if (this.Config.GetMaximumNumberOfPlans() == 0) {
            return true;
        }
        return numberofplans < this.Config.GetMaximumNumberOfPlans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EngineStatus EngineStatus() {
        EngineStatus stats = new EngineStatus();
        Object object = lockMe;
        synchronized (object) {
            stats.NumberOfPlans = this.Executors.size();
            stats.NumberOfRunningPlans = 0;
            stats.NumberOfCompletedPlans = 0;
            stats.NumberOfReadyPlans = 0;
            stats.NumberOfPausedPlans = 0;
            stats.NumberOfCancelingPlans = 0;
            stats.PercentageOfUtilization = 0.0f;
            for (PlanExecutor exec : this.Executors) {
                switch (exec.GetHandle().GetHandleState()) {
                    case Completed: {
                        ++stats.NumberOfCompletedPlans;
                        break;
                    }
                    case Ready: {
                        ++stats.NumberOfReadyPlans;
                        stats.PercentageOfUtilization += exec.GetHandle().GetPlan().Config.Utiliaztion;
                        break;
                    }
                    case Paused: {
                        ++stats.NumberOfPausedPlans;
                        break;
                    }
                    case Running: {
                        ++stats.NumberOfRunningPlans;
                        stats.PercentageOfUtilization += exec.GetHandle().GetPlan().Config.Utiliaztion;
                        break;
                    }
                    case Cancel: {
                        ++stats.NumberOfCancelingPlans;
                    }
                }
            }
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void RemoveExecutor(PlanExecutor executor) {
        Object object = lockMe;
        synchronized (object) {
            executor.Dispose();
            ExecutionEngine.Engine.Executors.remove(executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isInitialized() throws ExecutionInternalErrorException {
        Object object = lockMe;
        synchronized (object) {
            return Engine != null;
            {
            }
        }
    }
}

