/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.datatype;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.datatype.ReflectableItem;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.utils.ReflectableAnalyzer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTypeReflectable
implements IDataType,
Iterable<ReflectableItem> {
    private ReflectableItem[] Items = null;

    @Override
    public Iterator<ReflectableItem> iterator() {
        return Arrays.asList(this.Items).iterator();
    }

    @Override
    public boolean CanSuggestDataTypeClass() {
        return false;
    }

    @Override
    public Class<?> GetDataTypeClass() {
        return null;
    }

    @Override
    public IDataType.DataTypes GetDataTypeEnum() {
        return IDataType.DataTypes.Reflectable;
    }

    @Override
    public String GetStringValue() throws ExecutionSerializationException {
        return this.ToXML();
    }

    @Override
    public void SetStringValue(String val) throws ExecutionValidationException, ExecutionSerializationException {
        this.FromXML(val);
    }

    @Override
    public Object GetValue() {
        return this;
    }

    public ReflectableItem[] GetItems() {
        return this.Items;
    }

    @Override
    public void SetValue(Object Value) throws ExecutionValidationException {
        String ErrorString = null;
        if (Value == null) {
            this.Items = null;
            return;
        }
        if (Value instanceof ReflectableItem[]) {
            this.Items = (ReflectableItem[])Value;
            return;
        }
        if (Value instanceof DataTypeReflectable) {
            this.Items = ((DataTypeReflectable)Value).Items;
            return;
        }
        if (Value instanceof String) {
            try {
                this.FromXML((String)Value);
                return;
            }
            catch (Exception ex) {
                ErrorString = ex.getMessage();
            }
        } else {
            ReflectableAnalyzer analyzer = new ReflectableAnalyzer(Value.getClass(), null);
            if (analyzer.CanRepresentAsReflectable()) {
                try {
                    DataTypeReflectable refl = analyzer.ProduceReflectable(Value);
                    if (refl != null) {
                        this.Items = refl.Items;
                        return;
                    }
                    ErrorString = "Given value cannot be represented as a reflectable";
                }
                catch (Exception ex) {
                    ErrorString = ex.getMessage();
                }
            } else {
                ErrorString = "Given value cannot be represented as a reflectable";
            }
        }
        throw new ExecutionValidationException("Incompatible types. Expecting " + this.GetDataTypeEnum().toString() + ", String or something reflectabe and found " + Value.getClass().getName() + " with error from process(" + ErrorString + ")");
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)XML, (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!IDataType.DataTypes.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetDataTypeEnum())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            Element valelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"value");
            if (valelem == null) {
                throw new ExecutionSerializationException("Provided Serialization is not valid");
            }
            Element itemselem = XMLUtils.GetChildElementWithName((Node)valelem, (String)"items");
            if (itemselem == null) {
                this.Items = null;
            } else {
                List itemslst = XMLUtils.GetChildElementsWithName((Node)itemselem, (String)"item");
                if (itemslst.size() == 0) {
                    this.Items = null;
                } else {
                    this.Items = new ReflectableItem[itemslst.size()];
                    for (int i = 0; i < itemslst.size(); ++i) {
                        ReflectableItem it = new ReflectableItem();
                        it.FromXML((Element)itemslst.get(i));
                        this.Items[i] = it;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<dt type=\"" + this.GetDataTypeEnum().toString() + "\">");
        buf.append("<value>");
        buf.append("<items>");
        if (this.Items != null) {
            for (ReflectableItem item : this.Items) {
                buf.append(item.ToXML());
            }
        }
        buf.append("</items>");
        buf.append("</value>");
        buf.append("</dt>");
        return buf.toString();
    }
}

