/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.utils.PlanElementUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SequencePlanElement
extends PlanElementBase
implements Iterable<IPlanElement> {
    private static Logger logger = LoggerFactory.getLogger(SequencePlanElement.class);
    private String ID = UUID.randomUUID().toString();
    private String Name = SequencePlanElement.class.getSimpleName();
    public List<IPlanElement> ElementCollection = new ArrayList<IPlanElement>();

    @Override
    public Iterator<IPlanElement> iterator() {
        return this.ElementCollection.iterator();
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element listnode = XMLUtils.GetChildElementWithName((Node)XML, (String)"list");
            if (listnode == null) {
                throw new ExecutionSerializationException("Not valid serialization");
            }
            List lstmembers = XMLUtils.GetChildElementsWithName((Node)listnode, (String)"planElement");
            this.ElementCollection.clear();
            for (Element lstm : lstmembers) {
                this.ElementCollection.add(PlanElementUtils.GetPlanElement(lstm));
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.Sequence;
    }

    @Override
    public IPlanElement Locate(String ID) {
        if (this.ID.equals(ID)) {
            return this;
        }
        for (IPlanElement elem : this) {
            IPlanElement e = elem.Locate(ID);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        for (IPlanElement elem : this) {
            acts.addAll(elem.LocateActionElements());
        }
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append("<list>");
        for (IPlanElement elem : this) {
            buf.append(elem.ToXML());
        }
        buf.append("</list>");
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.ElementCollection == null || this.ElementCollection.size() == 0) {
            throw new ExecutionValidationException("Element collection not set");
        }
        for (IPlanElement elem : this) {
            elem.Validate();
        }
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[0];
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return false;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return new ArrayList<ContingencyTrigger>();
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (IPlanElement elem : this.ElementCollection) {
            vars.addAll(elem.GetModifiedVariableNames());
        }
        return vars;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (IPlanElement elem : this.ElementCollection) {
            vars.addAll(elem.GetNeededVariableNames());
        }
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        String[] params = Handle.getHostingNodeInfo().split(":");
        int port = Integer.parseInt(params[1]);
        int TotalSteps = this.ElementCollection.size() + 2;
        logger.debug("Starting");
        this.CheckStatus(Handle);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, TotalSteps, "Starting Execution of " + this.Name, this.Name, params[0], port));
        }
        this.StopClock(PlanElementBase.ClockType.Init);
        for (int i = 0; i < this.ElementCollection.size(); ++i) {
            this.StartClock(PlanElementBase.ClockType.Init);
            this.CheckStatus(Handle);
            this.StopClock(PlanElementBase.ClockType.Init);
            logger.debug("Executing Element " + (i + 1) + " of " + this.ElementCollection.size());
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1 + (i + 1), TotalSteps, "Starting Execution of element " + (i + 1) + " of " + this.ElementCollection.size()));
            }
            this.StartClock(PlanElementBase.ClockType.Children);
            this.ElementCollection.get(i).Execute(Handle);
            this.StopClock(PlanElementBase.ClockType.Children);
        }
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), TotalSteps, TotalSteps, "Finishing Execution of " + this.Name, this.Name, params[0], port));
        }
        logger.debug("Exiting");
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
    }
}

