/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.engine;

import gr.uoa.di.madgik.execution.engine.EngineStatus;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionCompletedStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionStartedStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionException;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.notificationhandling.NotificationHandling;
import java.io.File;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanExecutor
extends Thread
implements Observer {
    private Logger logger = LoggerFactory.getLogger(PlanExecutor.class);
    private ExecutionHandle Handle = null;

    public PlanExecutor(ExecutionHandle Handle) {
        this.Handle = Handle;
        this.RegisterForEvents();
        this.setName(PlanExecutor.class.getName());
        this.setDaemon(true);
    }

    public ExecutionHandle GetHandle() {
        return this.Handle;
    }

    private void RegisterForEvents() {
        ExecutionStateEvent ev = this.Handle.GetEvent(ExecutionStateEvent.EventName.ExecutionCompleted);
        if (ev != null) {
            ev.addObserver(this);
        }
    }

    @Override
    public void run() {
        PlanExecutor.notifyMonitoring();
        try {
            this.logger.debug("running executor");
            this.Handle.PlanRunning();
            this.Handle.EmitEvent(new ExecutionStartedStateEvent());
            this.Handle.GetPlan().Root.Execute(this.Handle);
            this.Handle.SetIsCompleted(true);
            this.Handle.SetIsCompletedWithError(false);
            this.Handle.SetIsCompletedWithSuccess(true);
            this.Handle.SetCompletionError(null);
        }
        catch (ExecutionException ex) {
            this.logger.debug("Could not complete successfully the plan execution", (Throwable)ex);
            this.Handle.SetIsCompleted(true);
            this.Handle.SetIsCompletedWithError(true);
            this.Handle.SetIsCompletedWithSuccess(false);
            this.Handle.SetCompletionError(ex);
        }
        this.Handle.PlanCompleted();
        this.Handle.EmitEvent(new ExecutionCompletedStateEvent());
        PlanExecutor.notifyMonitoring();
    }

    private static void notifyMonitoring() {
        try {
            EngineStatus status = ExecutionEngine.GetEngineStatus();
            String message = "hostname=";
            message = message + InformationSystem.GetLocalNodeHostName();
            message = message + ":";
            message = message + InformationSystem.GetLocalNodePort();
            message = message + ",load=";
            message = message + status.PercentageOfUtilization;
            String topicID = NotificationHandling.RegisterNotificationTopic((String)"NodeLoadMonitoring", (String)"ExecutionEngine", null);
            NotificationHandling.SendNotificationToTopic((String)topicID, (String)message, new HashMap(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            return;
        }
        if (arg instanceof ExecutionCompletedStateEvent) {
            ExecutionEngine.RemoveExecutor(this);
        }
    }

    public void Dispose() {
        ExecutionStateEvent ev = this.Handle.GetEvent(ExecutionStateEvent.EventName.ExecutionCompleted);
        if (ev != null) {
            ev.deleteObserver(this);
        }
        this.CleanUpFiles();
        this.Handle.Dispose();
    }

    private void CleanUpFiles() {
        for (String s : this.Handle.GetPlan().CleanUpLocalFiles) {
            try {
                String file = s;
                File f = new File(file);
                if (!f.exists() || !f.isFile() || f.delete()) continue;
                throw new Exception("Delete operation returned false. File prossibly not deleted");
            }
            catch (Exception ex) {
                this.logger.warn("Could not cleanup file of variable with location " + s);
            }
        }
    }
}

