/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.plan.trycatchfinally.CatchElement;
import gr.uoa.di.madgik.execution.utils.PlanElementUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TryCatchFinallyPlanElement
extends PlanElementBase {
    private static final Logger logger = Logger.getLogger(TryCatchFinallyPlanElement.class.getName());
    private String ID = UUID.randomUUID().toString();
    private String Name = TryCatchFinallyPlanElement.class.getSimpleName();
    public IPlanElement TryFlow = null;
    public List<CatchElement> CatchFlows = new ArrayList<CatchElement>();
    public IPlanElement FinallyFlow = null;

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element trynode = XMLUtils.GetChildElementWithName((Node)XML, (String)"try");
            if (trynode == null) {
                throw new ExecutionSerializationException("Not valid serialization");
            }
            Element plantrynode = XMLUtils.GetChildElementWithName((Node)trynode, (String)"planElement");
            if (plantrynode == null) {
                throw new ExecutionSerializationException("Not valid serialization");
            }
            this.TryFlow = PlanElementUtils.GetPlanElement(plantrynode);
            Element finallynode = XMLUtils.GetChildElementWithName((Node)XML, (String)"finally");
            if (finallynode == null) {
                throw new ExecutionSerializationException("Not valid serialization");
            }
            Element planfinallynode = XMLUtils.GetChildElementWithName((Node)finallynode, (String)"planElement");
            this.FinallyFlow = planfinallynode != null ? PlanElementUtils.GetPlanElement(planfinallynode) : null;
            Element catchnode = XMLUtils.GetChildElementWithName((Node)XML, (String)"catch");
            if (catchnode == null) {
                throw new ExecutionSerializationException("Not valid serialization");
            }
            List catchelems = XMLUtils.GetChildElementsWithName((Node)catchnode, (String)"catch");
            this.CatchFlows.clear();
            for (Element c : catchelems) {
                CatchElement ce = new CatchElement();
                ce.FromXML(c);
                this.CatchFlows.add(ce);
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.TryCatchFinally;
    }

    @Override
    public IPlanElement Locate(String ID) {
        IPlanElement elem;
        if (this.ID.equals(ID)) {
            return this;
        }
        if (this.TryFlow != null && (elem = this.TryFlow.Locate(ID)) != null) {
            return elem;
        }
        if (this.CatchFlows != null) {
            for (CatchElement ef : this.CatchFlows) {
                IPlanElement elem2;
                if (ef.Root == null || (elem2 = ef.Root.Locate(ID)) == null) continue;
                return elem2;
            }
        }
        if (this.FinallyFlow != null && (elem = this.FinallyFlow.Locate(ID)) != null) {
            return elem;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        if (this.TryFlow != null) {
            acts.addAll(this.TryFlow.LocateActionElements());
        }
        if (this.CatchFlows != null) {
            for (CatchElement ef : this.CatchFlows) {
                if (ef.Root == null) continue;
                acts.addAll(ef.Root.LocateActionElements());
            }
        }
        if (this.FinallyFlow != null) {
            acts.addAll(this.FinallyFlow.LocateActionElements());
        }
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append("<try>");
        buf.append(this.TryFlow.ToXML());
        buf.append("</try>");
        buf.append("<catch>");
        if (this.CatchFlows != null) {
            for (CatchElement c : this.CatchFlows) {
                buf.append(c.ToXML());
            }
        }
        buf.append("</catch>");
        buf.append("<finally>");
        if (this.FinallyFlow != null) {
            buf.append(this.FinallyFlow.ToXML());
        }
        buf.append("</finally>");
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.TryFlow == null) {
            throw new ExecutionValidationException("The try flow is not defined");
        }
        this.TryFlow.Validate();
        if (this.CatchFlows != null) {
            for (CatchElement catchf : this.CatchFlows) {
                catchf.Validate();
            }
        }
        if (this.FinallyFlow != null) {
            this.FinallyFlow.Validate();
        }
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[0];
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return false;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return new ArrayList<ContingencyTrigger>();
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        if (this.TryFlow != null) {
            vars.addAll(this.TryFlow.GetModifiedVariableNames());
        }
        for (CatchElement cf : this.CatchFlows) {
            vars.addAll(cf.GetModifiedVariableNames());
        }
        if (this.FinallyFlow != null) {
            vars.addAll(this.FinallyFlow.GetModifiedVariableNames());
        }
        return vars;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        if (this.TryFlow != null) {
            vars.addAll(this.TryFlow.GetNeededVariableNames());
        }
        for (CatchElement cf : this.CatchFlows) {
            vars.addAll(cf.GetNeededVariableNames());
        }
        if (this.FinallyFlow != null) {
            vars.addAll(this.FinallyFlow.GetNeededVariableNames());
        }
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        int CurrentStep = 1;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Starting");
        }
        this.CheckStatus(Handle);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), CurrentStep, CurrentStep + 1, "Starting Execution of " + this.Name));
        }
        ExecutionRunTimeException nex = null;
        this.StopClock(PlanElementBase.ClockType.Init);
        this.StartClock(PlanElementBase.ClockType.Children);
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Executing");
            }
            this.TryFlow.Execute(Handle);
        }
        catch (ExecutionRunTimeException ex) {
            nex = ex;
            this.CheckStatus(Handle);
            try {
                for (CatchElement ce : this.CatchFlows) {
                    ++CurrentStep;
                    if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                        Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), CurrentStep, CurrentStep + 1, "Seeking alternative flow in element " + this.Name + " because of error " + ex.GetCauseFullName() + " with message " + ex.getMessage()));
                    }
                    if (!ce.Execute(this.GetID(), Handle, ex)) continue;
                    nex = null;
                }
            }
            catch (ExecutionRunTimeException exx) {
                nex = exx;
            }
        }
        if (this.FinallyFlow != null) {
            this.CheckStatus(Handle);
            ++CurrentStep;
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), CurrentStep, CurrentStep + 1, "Finalizing in element " + this.Name));
            }
            this.FinallyFlow.Execute(Handle);
        }
        if (nex != null) {
            ++CurrentStep;
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), CurrentStep, CurrentStep + 1, "Throwing Exception caught in element " + this.Name + "after processing it for alternative flows"));
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exiting");
            }
            throw nex;
        }
        this.StopClock(PlanElementBase.ClockType.Children);
        ++CurrentStep;
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), CurrentStep, CurrentStep, "Finishing Execution of " + this.Name));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Exiting");
        }
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
    }
}

