/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.condition.ConditionalFlow;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.utils.PlanElementUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConditionalPlanElement
extends PlanElementBase {
    private static Logger logger = Logger.getLogger(ConditionalPlanElement.class.getName());
    private String ID = UUID.randomUUID().toString();
    private String Name = ConditionalPlanElement.class.getSimpleName();
    public ConditionalFlow IfFlow = null;
    public List<ConditionalFlow> ElseIfFlows = new ArrayList<ConditionalFlow>();
    public IPlanElement ElseFlow = null;

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element ifnode = XMLUtils.GetChildElementWithName((Node)XML, (String)"if");
            if (ifnode == null) {
                throw new ExecutionSerializationException("Not valid serialization provided");
            }
            Element ifpelnode = XMLUtils.GetChildElementWithName((Node)ifnode, (String)"conditionalFlow");
            this.IfFlow = new ConditionalFlow();
            this.IfFlow.FromXML(ifpelnode);
            Element elifnode = XMLUtils.GetChildElementWithName((Node)XML, (String)"elif");
            if (elifnode == null) {
                throw new ExecutionSerializationException("Not valid serialization provided");
            }
            List elifpelnode = XMLUtils.GetChildElementsWithName((Node)elifnode, (String)"conditionalFlow");
            this.ElseIfFlows.clear();
            for (Element el : elifpelnode) {
                ConditionalFlow f = new ConditionalFlow();
                f.FromXML(el);
                this.ElseIfFlows.add(f);
            }
            Element elsenode = XMLUtils.GetChildElementWithName((Node)XML, (String)"else");
            if (elsenode == null) {
                throw new ExecutionSerializationException("Not valid serialization provided");
            }
            Element elsepelnode = XMLUtils.GetChildElementWithName((Node)elsenode, (String)"planElement");
            this.ElseFlow = elsepelnode != null ? PlanElementUtils.GetPlanElement(elsepelnode) : null;
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.Conditional;
    }

    @Override
    public IPlanElement Locate(String ID) {
        if (this.ID.equals(ID)) {
            return this;
        }
        IPlanElement elem = this.IfFlow.Locate(ID);
        if (elem != null) {
            return elem;
        }
        if (this.ElseIfFlows != null) {
            for (ConditionalFlow elif : this.ElseIfFlows) {
                elem = elif.Locate(ID);
                if (elem == null) continue;
                return elem;
            }
        }
        if (this.ElseFlow != null && (elem = this.ElseFlow.Locate(ID)) != null) {
            return elem;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        acts.addAll(this.IfFlow.LocateActionElements());
        if (this.ElseIfFlows != null) {
            for (ConditionalFlow elif : this.ElseIfFlows) {
                acts.addAll(elif.LocateActionElements());
            }
        }
        if (this.ElseFlow != null) {
            acts.addAll(this.ElseFlow.LocateActionElements());
        }
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append("<if>");
        buf.append(this.IfFlow.ToXML());
        buf.append("</if>");
        buf.append("<elif>");
        if (this.ElseIfFlows != null) {
            for (ConditionalFlow cf : this.ElseIfFlows) {
                buf.append(cf.ToXML());
            }
        }
        buf.append("</elif>");
        buf.append("<else>");
        if (this.ElseFlow != null) {
            buf.append(this.ElseFlow.ToXML());
        }
        buf.append("</else>");
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.IfFlow == null) {
            throw new ExecutionValidationException("If condition must always have valid value");
        }
        this.IfFlow.Validate();
        if (this.ElseIfFlows != null) {
            for (ConditionalFlow elif : this.ElseIfFlows) {
                elif.Validate();
            }
        }
        if (this.ElseFlow != null) {
            this.ElseFlow.Validate();
        }
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[0];
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return false;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return new ArrayList<ContingencyTrigger>();
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.IfFlow.GetNeededVariableNames());
        for (ConditionalFlow flow : this.ElseIfFlows) {
            vars.addAll(flow.GetNeededVariableNames());
        }
        if (this.ElseFlow != null) {
            vars.addAll(this.ElseFlow.GetNeededVariableNames());
        }
        return vars;
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.IfFlow.GetModifiedVariableNames());
        for (ConditionalFlow flow : this.ElseIfFlows) {
            vars.addAll(flow.GetModifiedVariableNames());
        }
        if (this.ElseFlow != null) {
            vars.addAll(this.ElseFlow.GetModifiedVariableNames());
        }
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Starting");
        }
        this.CheckStatus(Handle);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, 3, "Starting Execution of " + this.Name));
        }
        this.InitializeCondition();
        boolean executedSubElement = false;
        if (this.IfFlow.Condition.EvaluateCondition(Handle)) {
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 2, 3, "Starting Execution of subelement"));
            }
            this.StopClock(PlanElementBase.ClockType.Init);
            this.StartClock(PlanElementBase.ClockType.Children);
            this.IfFlow.Root.Execute(Handle);
            this.StopClock(PlanElementBase.ClockType.Children);
            executedSubElement = true;
        } else {
            for (ConditionalFlow cf : this.ElseIfFlows) {
                if (!cf.Condition.EvaluateCondition(Handle)) continue;
                if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                    Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 2, 3, "Starting Execution of subelement"));
                }
                this.StopClock(PlanElementBase.ClockType.Init);
                this.StartClock(PlanElementBase.ClockType.Children);
                cf.Root.Execute(Handle);
                this.StopClock(PlanElementBase.ClockType.Children);
                executedSubElement = true;
                break;
            }
            if (!executedSubElement && this.ElseFlow != null) {
                if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                    Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 2, 3, "Starting Execution of subelement"));
                }
                this.StopClock(PlanElementBase.ClockType.Init);
                this.StartClock(PlanElementBase.ClockType.Children);
                this.ElseFlow.Execute(Handle);
                this.StopClock(PlanElementBase.ClockType.Children);
                executedSubElement = true;
            }
        }
        if (!executedSubElement) {
            this.StopClock(PlanElementBase.ClockType.Init);
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 2, 3, "None of the defined conditions matched"));
            }
        }
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 3, 3, "Finishing Execution of " + this.Name));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Exiting");
        }
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }

    private void InitializeCondition() {
        this.IfFlow.InitializeCondition();
        if (this.ElseIfFlows != null) {
            for (ConditionalFlow elif : this.ElseIfFlows) {
                elif.InitializeCondition();
            }
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
        this.IfFlow.ValidatePreExecution(Handle);
        if (this.ElseIfFlows != null) {
            for (ConditionalFlow elif : this.ElseIfFlows) {
                elif.ValidatePreExecution(Handle);
            }
        }
        if (this.ElseFlow != null) {
            this.ElseFlow.ValidatePreExecution(Handle);
        }
    }
}

