/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.invocable;

import gr.uoa.di.madgik.commons.channel.events.ChannelPayloadStateEvent;
import gr.uoa.di.madgik.commons.channel.events.ChannelStateEvent;
import gr.uoa.di.madgik.commons.channel.events.ObjectPayloadChannelEvent;
import gr.uoa.di.madgik.commons.channel.nozzle.ChannelInlet;
import gr.uoa.di.madgik.commons.channel.nozzle.ChannelOutlet;
import gr.uoa.di.madgik.commons.channel.nozzle.INozzleConfig;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.plan.element.invocable.NozzleEventPayload;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NozzleHandler
implements Observer {
    private static Logger logger = Logger.getLogger(NozzleHandler.class.getName());
    private ChannelInlet inlet = null;
    private ChannelOutlet outlet = null;
    private ExecutionHandle Handle = null;

    public IChannelLocator CreateInletNozzle(INozzleConfig Config, ExecutionHandle Handle) throws ExecutionInternalErrorException {
        this.inlet = new ChannelInlet(Config);
        this.Handle = Handle;
        this.RegisterForEvents();
        return this.inlet.GetLocator();
    }

    public void CreateOutletNozzle(IChannelLocator Locator) throws ExecutionInternalErrorException {
        this.outlet = new ChannelOutlet(Locator);
        this.RegisterForEvents();
    }

    public void Emitt(ChannelPayloadStateEvent Event) throws ExecutionInternalErrorException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Emiting event from Nozzle Handle");
        }
        if (this.inlet != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Emiting event from inlet");
            }
            this.inlet.Push(Event);
        } else if (this.outlet != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Emiting event from outlet");
            }
            this.outlet.Push(Event);
        } else {
            throw new ExecutionInternalErrorException("No nozzle is initialized");
        }
    }

    public void Dispose() throws ExecutionInternalErrorException {
        block5: {
            try {
                for (ChannelStateEvent ev : this.GetPublishedEvents()) {
                    ev.deleteObserver((Observer)this);
                }
                if (this.inlet != null) {
                    this.inlet.Dispose();
                    break block5;
                }
                if (this.outlet != null) {
                    this.outlet.Dispose();
                    break block5;
                }
                throw new ExecutionInternalErrorException("No nozzle is initialized");
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.SEVERE)) break block5;
                logger.log(Level.SEVERE, "Problem disposing Nozzle Handler", ex);
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        block18: {
            try {
                if (!o.getClass().getName().equals(arg.getClass().getName())) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Received invalid event");
                    }
                    return;
                }
                if (!(arg instanceof ChannelStateEvent)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Received invalid event");
                    }
                    return;
                }
                switch (((ChannelStateEvent)arg).GetEventName()) {
                    case ObjectPayload: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Received object payload event");
                        }
                        if (this.Handle == null && this.inlet != null) {
                            throw new ExecutionInternalErrorException("In inlet nozzle side no execution handle set to forward event");
                        }
                        if (this.Handle == null && this.outlet != null) {
                            return;
                        }
                        if (!(arg instanceof ObjectPayloadChannelEvent)) {
                            throw new ExecutionInternalErrorException("Reveived object payload event of unrecognized type");
                        }
                        if (!(((ObjectPayloadChannelEvent)arg).GetValue() instanceof NozzleEventPayload)) {
                            throw new ExecutionInternalErrorException("Reveived object payload event of unrecognized payload type");
                        }
                        if (((NozzleEventPayload)((ObjectPayloadChannelEvent)arg).GetValue()).ExecutionEngineEvent == null) {
                            throw new ExecutionInternalErrorException("Received nozzle event with no execution engine event set");
                        }
                        this.Handle.EmitEvent(((NozzleEventPayload)((ObjectPayloadChannelEvent)arg).GetValue()).ExecutionEngineEvent);
                        break;
                    }
                    case DisposeChannel: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Received dispose channel event");
                        }
                        this.Dispose();
                        break;
                    }
                    default: {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, "Received event " + ((ChannelStateEvent)arg).GetEventName() + " which was not expected");
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) break block18;
                logger.log(Level.WARNING, "Could not process event", ex);
            }
        }
    }

    private void RegisterForEvents() throws ExecutionInternalErrorException {
        for (ChannelStateEvent ev : this.GetPublishedEvents()) {
            ev.addObserver((Observer)this);
        }
    }

    private Collection<ChannelStateEvent> GetPublishedEvents() throws ExecutionInternalErrorException {
        Collection events = null;
        if (this.inlet != null) {
            events = this.inlet.GetNozzleEvents();
        } else if (this.outlet != null) {
            events = this.outlet.GetNozzleEvents();
        } else {
            throw new ExecutionInternalErrorException("No nozzle is initialized");
        }
        return events;
    }
}

