package gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.execution.plan.element.invocable.callback.CallbackManager;
import java.io.DataInputStream;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecEngCallbackTCPConnManagerEntry implements ITCPConnectionManagerEntry
{
	private static Logger logger=Logger.getLogger(ExecEngCallbackTCPConnManagerEntry.class.getName());

	public ExecEngCallbackTCPConnManagerEntry(){}
	
	public NamedEntry GetName()
	{
		return NamedEntry.ExecutionEngineCallback;
	}

	public void HandleConnection(Socket socket)
	{
		try
		{
			String ID=new DataInputStream(socket.getInputStream()).readUTF();
			CallbackManager.CallbackEvent(ID,socket);
		}catch(Exception ex)
		{
			if(logger.isLoggable(Level.WARNING)) logger.log(Level.WARNING, "Could not initialize boundary side protocol handling",ex);
		}
	}

	@Override
	public void HandleConnection(ObjectInputStream ois, Socket socket) {
		// TODO Auto-generated method stub
		
	}

}
