/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.is.elements.invocable;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemSerializationException;
import gr.uoa.di.madgik.environment.is.elements.invocable.Parameter;
import gr.uoa.di.madgik.environment.is.elements.invocable.ParameterType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Method {
    public String ID = UUID.randomUUID().toString();
    public boolean IsConstructor = false;
    public String Name = null;
    public String Signature = null;
    protected Map<String, Parameter> Parameters = new HashMap<String, Parameter>();
    public ParameterType ReturnValue = null;

    public void Add(Parameter p) {
        this.Parameters.put(p.Name, p);
    }

    public Parameter Get(String name) {
        if (!this.Parameters.containsKey(name)) {
            return null;
        }
        return this.Parameters.get(name);
    }

    public void FromXML(Element XML, String ClassName) throws EnvironmentInformationSystemSerializationException {
        try {
            Element callMethodElement;
            if (XMLUtils.AttributeExists((Element)XML, (String)"id").booleanValue()) {
                this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            }
            if ((callMethodElement = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"method", (String)"http://profile.execution.madgik.di.uoa.gr")) == null) {
                throw new EnvironmentInformationSystemException("Not Valid serialization");
            }
            if (!XMLUtils.AttributeExists((Element)callMethodElement, (String)"name").booleanValue()) {
                throw new EnvironmentInformationSystemException("Not Valid serialization");
            }
            this.Name = XMLUtils.GetAttribute((Element)callMethodElement, (String)"name");
            this.IsConstructor = ClassName.equals(this.Name);
            Element callSignatureElement = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"signature", (String)"http://profile.execution.madgik.di.uoa.gr");
            if (callSignatureElement == null) {
                throw new EnvironmentInformationSystemException("Not Valid serialization");
            }
            this.Signature = XMLUtils.GetChildText((Node)callSignatureElement);
            List callMethodArgumentsElementslst = XMLUtils.GetChildElementsWithNameAndNamespace((Node)XML, (String)"argument", (String)"http://profile.execution.madgik.di.uoa.gr");
            this.Parameters.clear();
            for (Element callMethodArgumentElement : callMethodArgumentsElementslst) {
                Parameter p = new Parameter();
                p.FromXML(callMethodArgumentElement, true);
                this.Add(p);
            }
            Element returnElem = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"return", (String)"http://profile.execution.madgik.di.uoa.gr");
            if (returnElem != null) {
                this.ReturnValue = new ParameterType();
                this.ReturnValue.FromXML(returnElem);
            }
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemSerializationException("Could not deserialize element", ex);
        }
    }

    public String ToXML(String type) throws EnvironmentInformationSystemSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<execprf:call type=\"" + type + "\" id=\"" + this.ID + "\">");
        buf.append("<execprf:method name=\"" + this.Name + "\"/>");
        buf.append("<execprf:signature>" + this.Signature + "</execprf:signature>");
        for (Parameter p : this.Parameters.values()) {
            buf.append(p.ToXML(type));
        }
        if (this.ReturnValue != null) {
            buf.append("<execprf:return>");
            buf.append(this.ReturnValue.ToXML());
            buf.append("</execprf:return>");
        }
        buf.append("</execprf:call>");
        return buf.toString();
    }
}

