/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.is.elements.invocable;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemSerializationException;
import gr.uoa.di.madgik.environment.is.elements.InvocableProfileInfo;
import gr.uoa.di.madgik.environment.is.elements.invocable.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ShellInvocableProfileInfo
extends InvocableProfileInfo
implements Serializable {
    private static final long serialVersionUID = -6822668010951864524L;
    public String ExecutableName = null;
    public boolean AreParametersBound = false;
    public List<Parameter> Parameters = new ArrayList<Parameter>();

    @Override
    public void FromXML(String XML) throws EnvironmentInformationSystemSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws EnvironmentInformationSystemSerializationException {
        try {
            Element itemElem;
            if (XMLUtils.AttributeExists((Element)XML, (String)"id").booleanValue()) {
                this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            }
            if ((itemElem = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"item", (String)"http://profile.execution.madgik.di.uoa.gr")) == null) {
                throw new EnvironmentInformationSystemException("Invalid serialization");
            }
            Element executableNameElem = XMLUtils.GetChildElementWithNameAndNamespace((Node)itemElem, (String)"executableName", (String)"http://profile.execution.madgik.di.uoa.gr");
            if (executableNameElem == null) {
                throw new EnvironmentInformationSystemException("Invalid serialization");
            }
            if (!XMLUtils.AttributeExists((Element)executableNameElem, (String)"value").booleanValue()) {
                throw new EnvironmentInformationSystemException("Not valid serialization");
            }
            this.ExecutableName = XMLUtils.GetAttribute((Element)executableNameElem, (String)"value");
            Element argumentsElem = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"arguments", (String)"http://profile.execution.madgik.di.uoa.gr");
            if (argumentsElem == null) {
                throw new EnvironmentInformationSystemException("Invalid serialization");
            }
            if (!XMLUtils.AttributeExists((Element)argumentsElem, (String)"bound").booleanValue()) {
                throw new EnvironmentInformationSystemException("Not valid serialization");
            }
            this.AreParametersBound = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)argumentsElem, (String)"bound"));
            if (this.AreParametersBound) {
                List shellArgumentsElementslst = XMLUtils.GetChildElementsWithNameAndNamespace((Node)argumentsElem, (String)"argument", (String)"http://profile.execution.madgik.di.uoa.gr");
                for (Element shellArgumentElement : shellArgumentsElementslst) {
                    Parameter p = new Parameter();
                    p.FromXML(shellArgumentElement, true);
                    this.Parameters.add(p);
                }
            }
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemSerializationException("Could not deserialize element", ex);
        }
    }

    @Override
    public String ToXML() throws EnvironmentInformationSystemSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<execprf:InvocableProfile xmlns:execprf=\"http://profile.execution.madgik.di.uoa.gr\" type=\"Shell\" id=\"" + this.ID + "\">");
        buf.append("<execprf:item>");
        buf.append("<execprf:executableName value=\"" + this.ExecutableName + "\"/>");
        buf.append("</execprf:item>");
        if (!this.AreParametersBound) {
            buf.append("<execprf:arguments bound=\"" + this.AreParametersBound + "\" />");
        } else {
            buf.append("<execprf:arguments>");
            for (Parameter p : this.Parameters) {
                buf.append(p.ToXML("Simple"));
            }
            buf.append("</execprf:arguments>");
        }
        buf.append("</execprf:InvocableProfile>");
        return buf.toString();
    }
}

