/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.is.elements.invocable;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemSerializationException;
import gr.uoa.di.madgik.environment.is.elements.invocable.Method;
import gr.uoa.di.madgik.environment.is.elements.invocable.Parameter;
import gr.uoa.di.madgik.environment.is.elements.invocable.WSParameterType;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSMethod
extends Method
implements Serializable {
    private static final long serialVersionUID = -7590114661605524464L;
    public String MethodURN;
    public String EnvelopeTemplate;
    public String ExecutioContextToken = null;

    public void FromXML(Element XML) throws EnvironmentInformationSystemSerializationException {
        try {
            Element callMethodElement;
            if (XMLUtils.AttributeExists((Element)XML, (String)"id").booleanValue()) {
                this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            }
            if ((callMethodElement = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"method", (String)"http://profile.execution.madgik.di.uoa.gr")) == null) {
                throw new EnvironmentInformationSystemException("Not Valid serialization");
            }
            if (!XMLUtils.AttributeExists((Element)callMethodElement, (String)"name").booleanValue()) {
                throw new EnvironmentInformationSystemException("Not Valid serialization");
            }
            this.Name = XMLUtils.GetAttribute((Element)callMethodElement, (String)"name");
            this.IsConstructor = false;
            Element callMethodURNElement = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"methodURN", (String)"http://profile.execution.madgik.di.uoa.gr");
            if (callMethodURNElement == null) {
                throw new EnvironmentInformationSystemException("Not Valid serialization");
            }
            if (!XMLUtils.AttributeExists((Element)callMethodURNElement, (String)"name").booleanValue()) {
                throw new EnvironmentInformationSystemException("Not Valid serialization");
            }
            this.MethodURN = XMLUtils.GetAttribute((Element)callMethodURNElement, (String)"name");
            Element callSignatureElement = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"signature", (String)"http://profile.execution.madgik.di.uoa.gr");
            if (callSignatureElement == null) {
                throw new EnvironmentInformationSystemException("Not Valid serialization");
            }
            this.Signature = XMLUtils.GetChildText((Node)callSignatureElement);
            Element callMethodTemplateElement = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"envelopeTemplate", (String)"http://profile.execution.madgik.di.uoa.gr");
            if (callMethodTemplateElement == null) {
                throw new EnvironmentInformationSystemException("Not Valid serialization");
            }
            this.EnvelopeTemplate = XMLUtils.GetChildCDataText((Node)callMethodTemplateElement);
            Element callMethodTokenElement = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"executionContextToken", (String)"http://profile.execution.madgik.di.uoa.gr");
            if (callMethodTokenElement == null) {
                throw new EnvironmentInformationSystemException("Not Valid serialization");
            }
            this.ExecutioContextToken = XMLUtils.GetChildText((Node)callMethodTokenElement);
            List callMethodArgumentsElementslst = XMLUtils.GetChildElementsWithNameAndNamespace((Node)XML, (String)"argument", (String)"http://profile.execution.madgik.di.uoa.gr");
            this.Parameters.clear();
            for (Element callMethodArgumentElement : callMethodArgumentsElementslst) {
                Parameter p = new Parameter();
                p.FromXML(callMethodArgumentElement, false);
                this.Add(p);
            }
            Element returnElem = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"return", (String)"http://profile.execution.madgik.di.uoa.gr");
            if (returnElem != null) {
                this.ReturnValue = new WSParameterType();
                this.ReturnValue.FromXML(returnElem);
            }
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemSerializationException("Could not deserialize element", ex);
        }
    }

    @Override
    public String ToXML(String type) throws EnvironmentInformationSystemSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<execprf:call type=\"" + type + "\" id=\"" + this.ID + "\">");
        buf.append("<execprf:method name=\"" + this.Name + "\"/>");
        buf.append("<execprf:methodURN name=\"" + this.MethodURN + "\"/>");
        buf.append("<execprf:signature>" + this.Signature + "</execprf:signature>");
        buf.append("<execprf:envelopeTemplate><![CDATA[");
        buf.append(this.EnvelopeTemplate);
        buf.append("]]></execprf:envelopeTemplate>");
        buf.append("<execprf:executionContextToken>");
        buf.append(this.ExecutioContextToken);
        buf.append("</execprf:executionContextToken>");
        for (Parameter p : this.Parameters.values()) {
            buf.append(p.ToXML(type));
        }
        if (this.ReturnValue != null) {
            buf.append("<execprf:return>");
            buf.append(this.ReturnValue.ToXML());
            buf.append("</execprf:return>");
        }
        buf.append("</execprf:call>");
        return buf.toString();
    }

    public static enum ExtractType {
        String,
        Node;

    }
}

