/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.gcube.common.core.security.utils.constants.DelegationConstants;
import org.gcube.common.core.security.utils.constants.ProxyTypeConstants;
import org.gcube.vomanagement.vomsapi.util.VOMSFQANFactory;
import org.gcube.vomanagement.vomsapi.util.VOMSFQANInfo;
import org.glite.voms.contact.VOMSProxyInit;
import org.glite.voms.contact.VOMSRequestOptions;
import org.glite.voms.contact.VOMSServerInfo;

public class VOMSProxyFactory
implements ProxyTypeConstants,
DelegationConstants {
    private static Logger logger = Logger.getLogger(VOMSProxyFactory.class);
    protected String commandName = "voms-proxy-init";
    private File cadir;
    private File confile;
    private File output;
    private Integer hours;
    private Integer vomslife;
    private boolean limited;
    private boolean quiet;
    private boolean verify;
    private String proxyType;
    private String delegationType;
    private String policyType;
    private List<VOMSServerInfo> vomsServerList = new ArrayList<VOMSServerInfo>();
    private Set<VOMSFQANInfo> vomsInfo = new HashSet<VOMSFQANInfo>();

    public VOMSProxyFactory() {
    }

    public VOMSProxyFactory(File cadir, File confile, File output, Integer hours, Integer vomslife, boolean limited, boolean quiet, boolean verify, Set<VOMSFQANInfo> vomsInfo) {
        this.cadir = cadir;
        this.confile = confile;
        this.output = output;
        this.hours = hours;
        this.vomslife = vomslife;
        this.limited = limited;
        this.quiet = quiet;
        this.verify = verify;
        this.vomsInfo = vomsInfo;
    }

    public synchronized void createProxy(File certificate, File key, String password) throws IOException, InterruptedException {
        if (certificate == null) {
            throw new IllegalArgumentException("The certificate file is null");
        }
        if (!certificate.exists()) {
            throw new IllegalArgumentException("The certificate file " + certificate.getPath() + " does not exists");
        }
        if (!certificate.isFile()) {
            throw new IllegalArgumentException("The certificate file " + certificate.getPath() + " is not a regular file");
        }
        if (key != null) {
            if (!key.exists()) {
                throw new IllegalArgumentException("The key file " + key.getPath() + " does not exists");
            }
            if (!key.isFile()) {
                throw new IllegalArgumentException("The key file " + key.getPath() + " is not a regular file");
            }
        }
        if (key != null) {
            this.setupUserCredentials(certificate.getPath(), key.getPath());
        } else {
            this.setupUserCredentials(certificate.getPath(), certificate.getPath());
        }
        this.buildProxy(certificate, key, password);
    }

    public void createProxy(File proxyFile) throws IOException, InterruptedException {
        this.createProxy(proxyFile, proxyFile, null);
    }

    public void createProxy(File certificate, File key) throws IOException, InterruptedException {
        this.createProxy(certificate, key, null);
    }

    public synchronized File getCAdir() {
        return this.cadir;
    }

    public synchronized void setCertdir(File cadir) {
        if (!cadir.exists() || !cadir.isDirectory()) {
            throw new IllegalArgumentException("The certificate directory " + cadir.getPath() + " is not a valid directory");
        }
        this.cadir = cadir;
    }

    public synchronized File getConfile() {
        return this.confile;
    }

    public synchronized void setConfile(File confile) {
        if (!confile.exists() || !confile.isFile()) {
            throw new IllegalArgumentException("The configuration file " + confile.getPath() + " is not a valid configuration file");
        }
        this.confile = confile;
    }

    public synchronized Integer getHours() {
        return this.hours;
    }

    public synchronized void setHours(Integer hours) {
        this.hours = hours;
    }

    public synchronized boolean isLimited() {
        return this.limited;
    }

    public synchronized void setLimited(boolean limited) {
        this.limited = limited;
    }

    public synchronized boolean isQuiet() {
        return this.quiet;
    }

    public synchronized void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public synchronized boolean isVerify() {
        return this.verify;
    }

    public synchronized void setVerify(boolean verify) {
        this.verify = verify;
    }

    @Deprecated
    public synchronized Set<String> getVoms() {
        HashSet<String> vomses = new HashSet<String>();
        for (VOMSFQANInfo vomsInfo : this.vomsInfo) {
            vomses.add(vomsInfo.getString());
        }
        return vomses;
    }

    @Deprecated
    public synchronized void setVomses(Set<String> vomses) throws Exception {
        HashSet<VOMSFQANInfo> vomsInfo = new HashSet<VOMSFQANInfo>();
        for (String voms : vomses) {
            vomsInfo.add(VOMSFQANFactory.generateVOMSFQAN(voms));
        }
        this.vomsInfo = vomsInfo;
    }

    @Deprecated
    public synchronized void setVoms(String voms) throws Exception {
        this.vomsInfo.add(VOMSFQANFactory.generateVOMSFQAN(voms));
    }

    public synchronized Integer getVomslife() {
        return this.vomslife;
    }

    public synchronized void setVomslife(Integer vomslife) {
        this.vomslife = vomslife;
    }

    public synchronized File getOutput() {
        return this.output;
    }

    public synchronized void setOutput(File output) {
        this.output = output;
    }

    public Set<VOMSFQANInfo> getVomsFQANInfo() {
        return this.vomsInfo;
    }

    public void setVomsRoles(Set<VOMSFQANInfo> vomsInfo) {
        this.vomsInfo = vomsInfo;
    }

    public void addVomsFQANInfo(VOMSFQANInfo vomsInfo) {
        this.vomsInfo.add(vomsInfo);
    }

    protected void setupUserCredentials(String userCert, String userKey) {
        System.setProperty("X509_USER_CERT", userCert);
        System.setProperty("X509_USER_KEY", userKey);
    }

    protected void setupVomsesPath(String vomsesPath) {
        System.setProperty("VOMSES_LOCATION", vomsesPath);
    }

    protected void setupVomsdir(String vomsdir) {
        System.setProperty("VOMSDIR", vomsdir);
    }

    protected void setupCaDir(String caDir) {
        System.setProperty("CADIR", caDir);
    }

    public void addVomsServer(String hostName, String hostDN, int hostPort, String voName) {
        VOMSServerInfo info = new VOMSServerInfo();
        info.setHostDn(hostDN);
        info.setHostName(hostName);
        info.setPort(hostPort);
        info.setVoName(voName);
        this.vomsServerList.add(info);
    }

    private void buildProxy(File certificate, File key, String keyPassword) {
        VOMSProxyInit proxyInit = null;
        String proxyOutput = null;
        if (this.output != null) {
            proxyOutput = this.output.getAbsolutePath();
        }
        Object fqans = null;
        String ordering = null;
        if (keyPassword != null) {
            proxyInit = VOMSProxyInit.instance((String)keyPassword);
        } else {
            logger.warn((Object)"No password given to decrypt the openssl private key...");
            proxyInit = VOMSProxyInit.instance();
        }
        for (VOMSServerInfo serverInfo : this.vomsServerList) {
            proxyInit.addVomsServer(serverInfo);
        }
        if (proxyOutput != null) {
            proxyInit.setProxyOutputFile(proxyOutput);
        }
        if (this.proxyType != null) {
            int type = 2;
            if (this.proxyType.equals("GT2_PROXY")) {
                type = 2;
            } else if (this.proxyType.equals("GT3_PROXY")) {
                type = 3;
            } else if (this.proxyType.equals("GT4_PROXY")) {
                type = 4;
            } else {
                logger.warn((Object)"Unsupported proxy type specified! The default value will be used.");
            }
            proxyInit.setProxyType(type);
        }
        if (this.policyType != null) {
            proxyInit.setPolicyType(this.policyType);
        }
        if (this.delegationType != null) {
            int type = 3;
            if (this.delegationType.equals("NONE")) {
                type = 1;
            } else if (this.delegationType.equals("LIMITED")) {
                type = 2;
            } else if (this.delegationType.equals("FULL")) {
                type = 3;
            } else {
                logger.warn((Object)"Unsupported delegation type specified! The default value will be used.");
            }
            proxyInit.setDelegationType(type);
        }
        if (this.vomsInfo.isEmpty()) {
            proxyInit.getVomsProxy();
        } else {
            HashMap<String, VOMSRequestOptions> options = new HashMap<String, VOMSRequestOptions>();
            for (VOMSFQANInfo vomsInfo : this.vomsInfo) {
                VOMSRequestOptions o;
                String voName = vomsInfo.getVoName();
                if (options.containsKey(voName)) {
                    o = (VOMSRequestOptions)options.get(voName);
                } else {
                    o = new VOMSRequestOptions();
                    o.setVoName(voName);
                    options.put(voName, o);
                }
                String fqan = vomsInfo.getFQAN();
                if (fqan != null) {
                    o.addFQAN(fqan);
                }
                if (ordering == null) continue;
                o.setOrdering(ordering);
            }
            proxyInit.getVomsProxy(options.values());
        }
        logger.debug((Object)("fqans:" + ToStringBuilder.reflectionToString(fqans)));
    }

    public void setProxyType(String proxyType) {
        this.proxyType = proxyType;
    }

    public void setDelegationType(String delegationType) {
        this.delegationType = delegationType;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }
}

