/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.impl.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.log4j.Logger;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationException;
import org.gcube.vomanagement.vomsapi.impl.VOMSAdminException;
import org.gcube.vomanagement.vomsapi.impl.ssl.MyX509KeyManager;
import org.gcube.vomanagement.vomsapi.impl.ssl.MyX509TrustManager;
import org.gcube.vomanagement.vomsapi.util.CredentialsUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.gridforum.jgss.ExtendedGSSCredential;

public class MySSLSocketFactory
extends DefaultSocketFactory
implements SecureSocketFactory {
    public static final Object LOCK = new Object();
    private static Logger logger = Logger.getLogger((String)MySSLSocketFactory.class.getName());
    protected static SSLSocketFactory sslFactory = null;

    public MySSLSocketFactory(Hashtable attributes) throws Exception {
        super(attributes);
        logger.info((Object)"A MySSLSocketFactory has been created!");
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        if (sslFactory == null) {
            throw new VOMSAdminException("A SSLSocketFactory has not been configured for the current Axis call!!");
        }
        logger.debug((Object)("create secure socket for VOMS-API to " + host + ":" + port + " using the SSLFactory " + sslFactory));
        SSLSocket socket = (SSLSocket)sslFactory.createSocket();
        socket.setEnabledProtocols(new String[]{"SSLv3"});
        String[] ciphers = socket.getEnabledCipherSuites();
        ArrayList<String> al = new ArrayList<String>(ciphers.length);
        for (int i = 0; i < ciphers.length; ++i) {
            if (ciphers[i].indexOf("RC4") != -1) continue;
            al.add(ciphers[i]);
        }
        socket.setEnabledCipherSuites(al.toArray(new String[al.size()]));
        socket.setUseClientMode(true);
        socket.setSoTimeout(30000);
        socket.connect(new InetSocketAddress(host, port), 3000);
        logger.debug((Object)("Socket created to " + host + ":" + port + "using the SSLFactory " + sslFactory));
        return socket;
    }

    public static SSLSocketFactory createSSLFactory(ExtendedGSSCredential credentials) throws VOMSAPIConfigurationException {
        SSLContext sctx;
        TrustManager[] trustManagers;
        logger.info((Object)"Registering MySSLSocketFactory as SecureSocketFactory in Axis");
        System.setProperty("org.apache.axis.components.net.SecureSocketFactory", MySSLSocketFactory.class.getName());
        logger.debug((Object)"The MySSLSocketFactory has been registered as SecureSocketFactory in Axis");
        logger.info((Object)("Parsing " + CredentialsUtil.stringCredentials(credentials) + " to get the private key, the public certificate " + "and the trusted authorities"));
        Certificate[] certs = null;
        PrivateKey key = null;
        X509Certificate[] trustedCerts = null;
        if (!(credentials instanceof GlobusGSSCredentialImpl)) {
            logger.error((Object)"Cannot parse credentials as the credentials object is not an instance of GlobusGSSCredentialImpl");
            throw new VOMSAPIConfigurationException("Cannot parse credentials as the credentials object is not an instance of GlobusGSSCredentialImpl");
        }
        GlobusCredential globusCred = ((GlobusGSSCredentialImpl)credentials).getGlobusCredential();
        key = globusCred.getPrivateKey();
        certs = globusCred.getCertificateChain();
        trustedCerts = new X509Certificate[]{certs[certs.length - 1]};
        logger.debug((Object)("Correctly parsed " + CredentialsUtil.stringCredentials(credentials)));
        logger.info((Object)"Creating KeyManager and TrustManager to initialize the SSLContext");
        KeyManager[] keyManagers = new KeyManager[]{new MyX509KeyManager(certs, key)};
        try {
            trustManagers = new TrustManager[]{new MyX509TrustManager(trustedCerts)};
        }
        catch (IOException e) {
            logger.error((Object)"Cannot create the MyX509TrustManager", (Throwable)e);
            throw new VOMSAPIConfigurationException("Cannot create the MyX509TrustManager", e);
        }
        logger.debug((Object)"created KeyManager and TrustManager to initialize the SSLContext");
        logger.info((Object)"creating the SSLContext and SSLSocketFactory");
        try {
            sctx = SSLContext.getInstance("SSL");
            sctx.init(keyManagers, trustManagers, null);
        }
        catch (Exception e) {
            logger.error((Object)"Cannot create the SSLContext", (Throwable)e);
            throw new VOMSAPIConfigurationException("Cannot create the SSLContext", e);
        }
        SSLSocketFactory sslFactory = sctx.getSocketFactory();
        logger.info((Object)"new SSLSocketFactory created");
        return sslFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetSSLFactory() {
        Object object = LOCK;
        synchronized (object) {
            sslFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentSSLFactory(SSLSocketFactory sslFactory) {
        Object object = LOCK;
        synchronized (object) {
            MySSLSocketFactory.sslFactory = sslFactory;
        }
    }
}

