/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.impl;

import java.rmi.RemoteException;
import javax.xml.rpc.Stub;
import org.apache.log4j.Logger;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationProperty;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIFactory;
import org.gcube.vomanagement.vomsapi.util.CredentialsUtil;
import org.glite.security.voms.FQAN;
import org.globus.wsrf.impl.security.authentication.Constants;
import sun.security.validator.ValidatorException;

abstract class VOMSAPIStub {
    private static final String ROLE_PREFIX = "Role=";
    private VOMSAPIFactory factory;

    VOMSAPIStub(VOMSAPIFactory factory) {
        this.factory = factory;
    }

    VOMSAPIFactory getFactory() {
        return this.factory;
    }

    abstract void configureVOMSAPIStubForCall();

    void configureSecurity(Stub stub) {
        stub._setProperty("org.globus.gsi.credentials", (Object)this.factory.getVOMSAPIConfiguration().getCredentials());
        stub._setProperty("org.globus.security.transport.type", (Object)Constants.ENCRYPTION);
    }

    String getCA() {
        return this.factory.getVOMSAPIConfiguration().getProperty(VOMSAPIConfigurationProperty.SIMPLE_CA);
    }

    String getDN(String userName) {
        return this.factory.getVOMSAPIConfiguration().getProperty(VOMSAPIConfigurationProperty.CN_PREFIX) + userName;
    }

    String getRoleFromFQAN(String fqanString) {
        FQAN fqan = new FQAN(fqanString);
        String role = fqan.getRole();
        if (role == null || "".equals(role)) {
            throw new NullPointerException("The FQAN string \"" + fqanString + "\" does not contains any role");
        }
        return role;
    }

    String getGroupFromFQAN(String fqanString) {
        FQAN fqan = new FQAN(fqanString);
        String group = fqan.getGroup();
        if (group == null || "".equals(group)) {
            throw new NullPointerException("The FQAN string \"" + fqanString + "\" does not contains any group");
        }
        return group;
    }

    String[] discardRolePrefix(String[] roles) {
        if (roles == null) {
            throw new NullPointerException("The array of roles cannot be null");
        }
        String[] cleanedRoles = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            cleanedRoles[i] = this.discardRolePrefix(roles[i]);
        }
        return cleanedRoles;
    }

    String discardRolePrefix(String role) {
        if (role == null) {
            throw new NullPointerException("The role cannot be null");
        }
        return role.startsWith(ROLE_PREFIX) ? role.substring(5) : role;
    }

    String addRolePrefix(String role) {
        if (role == null) {
            throw new NullPointerException("The role cannot be null");
        }
        return role.startsWith(ROLE_PREFIX) ? role : ROLE_PREFIX + role;
    }

    void handleException(RemoteException e, Logger logger) {
        if (e.detail != null && e.detail.getCause() != null && e.detail.getCause().getClass().equals(ValidatorException.class)) {
            logger.debug((Object)e);
            if (this.factory.getVOMSAPIConfiguration().getCredentials() == null) {
                logger.error((Object)">>> Cannot find credentials to contact VOMS. Please configure credentials in the VOMSAPIConfiguration object");
            } else if (CredentialsUtil.isExpired(this.factory.getVOMSAPIConfiguration().getCredentials())) {
                logger.error((Object)(">>> " + CredentialsUtil.stringCredentials(this.factory.getVOMSAPIConfiguration().getCredentials()) + " are expired!"));
            }
            logger.error((Object)(">>> If the voms-api library is running from a standalone client, the value of the configuration property " + VOMSAPIConfigurationProperty.RUNS_IN_WS_CORE.toString() + " in the configuration file should be set to false (current value is " + this.getFactory().getVOMSAPIConfiguration().runsInWSCore() + ")"));
        }
    }
}

