/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import org.apache.log4j.Logger;
import org.gcube.common.core.security.utils.ProxyUtil;
import org.glite.security.util.FileCertReader;
import org.glite.security.voms.BasicVOMSTrustStore;
import org.glite.security.voms.FQAN;
import org.glite.security.voms.VOMSAttribute;
import org.glite.security.voms.VOMSValidator;
import org.glite.security.voms.ac.ACTrustStore;
import org.globus.gsi.gssapi.GSSConstants;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSException;

public class VOMSAttributesReader {
    private static Logger logger = Logger.getLogger(VOMSAttributesReader.class);
    private static final String PROPERTIES_FILE = "VOMSAttributeReader.properties";
    public static final String DEFAULT_TRUST_STORE_LISTING = "/etc/grid-security/vomsdir/*.pem";
    public static final long REFRESH_PERIOD = 0L;
    private String defaultTrustStoreListing = "/etc/grid-security/vomsdir/*.pem";
    private long refreshPeriod = 0L;
    private VOMSValidator validator;
    private VOMSAttribute[] vomsAttributes = new VOMSAttribute[0];

    protected VOMSAttributesReader() throws IOException {
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(PROPERTIES_FILE);
        if (is != null) {
            Properties prop = new Properties();
            prop.load(is);
            is.close();
            Set<Object> keySet = prop.keySet();
            if (keySet.contains("DEFAULT_TRUST_STORE_LISTING")) {
                this.defaultTrustStoreListing = prop.getProperty("DEFAULT_TRUST_STORE_LISTING");
            }
            if (keySet.contains("REFRESH_PERIOD")) {
                this.refreshPeriod = Long.parseLong(prop.getProperty("REFRESH_PERIOD"));
            }
        }
    }

    public VOMSAttributesReader(X509Certificate[] certificateChain) throws Exception, IOException {
        this();
        this.extractVOMSAttributes(certificateChain, this.defaultTrustStoreListing, this.refreshPeriod);
    }

    public VOMSAttributesReader(X509Certificate[] certificateChain, String trustStoreListing, long refresh) throws Exception {
        this.extractVOMSAttributes(certificateChain, trustStoreListing, refresh);
    }

    public VOMSAttributesReader(String proxyPath) throws Exception, IOException {
        this();
        this.init(proxyPath, this.defaultTrustStoreListing, this.refreshPeriod);
    }

    public VOMSAttributesReader(String proxyPath, String trustStoreListing, long refresh) throws Exception {
        this.init(proxyPath, trustStoreListing, refresh);
    }

    public VOMSAttributesReader(Subject peerSubject, MessageContext context) throws Exception, IOException {
        this();
        this.init(peerSubject, context, this.defaultTrustStoreListing, this.refreshPeriod);
    }

    public VOMSAttributesReader(Subject peerSubject, MessageContext context, String trustStoreListing, long refresh) throws Exception {
        this.init(peerSubject, context, trustStoreListing, refresh);
    }

    public VOMSAttributesReader(ExtendedGSSCredential cred) throws Exception, GSSException, CertificateException, IOException {
        this();
        this.init(cred, this.defaultTrustStoreListing, this.refreshPeriod);
    }

    public VOMSAttributesReader(ExtendedGSSCredential cred, String trustStoreListing, long refresh) throws Exception, GSSException, CertificateException, IOException {
        this.init(cred, trustStoreListing, refresh);
    }

    private void extractVOMSAttributes(X509Certificate[] certs, String defaultTrustStoreListing, long refreshPeriod) throws Exception {
        X509Certificate[] orderCerts = ProxyUtil.orderChain((X509Certificate[])certs);
        String certsStr = "Certificates to parse: \n";
        int i = 0;
        for (X509Certificate certificate : orderCerts) {
            certsStr = certsStr + "\nCertificate number " + i + ":\n" + certificate + "\n\n";
            ++i;
        }
        logger.debug((Object)certsStr);
        try {
            BasicVOMSTrustStore store = new BasicVOMSTrustStore(defaultTrustStoreListing, refreshPeriod);
            VOMSValidator.setTrustStore((ACTrustStore)store);
            VOMSValidator validator = new VOMSValidator(orderCerts);
            validator = validator.validate();
            this.vomsAttributes = validator.getVOMSAttributes().toArray(new VOMSAttribute[0]);
            String vomsACStr = "Attributes found: ";
            for (VOMSAttribute attribute : this.vomsAttributes) {
                vomsACStr = vomsACStr + attribute + "\n";
            }
            logger.debug((Object)vomsACStr);
        }
        catch (Exception e) {
            String msg = "Problems in reading VOMS Attributes information from the certificate chain";
            logger.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    private void init(String certificatePath, String defaultTrustStoreListing, long refreshPeriod) throws Exception {
        try {
            FileCertReader certReader = new FileCertReader();
            Vector vector = certReader.readCerts(certificatePath);
            if (vector.size() > 0) {
                X509Certificate[] certs = new X509Certificate[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    certs[i] = (X509Certificate)vector.get(i);
                }
                this.extractVOMSAttributes(certs, defaultTrustStoreListing, refreshPeriod);
            }
        }
        catch (Exception e) {
            String msg = "Error in reading the certificate file";
            logger.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    private void init(Subject peerSubject, MessageContext context, String defaultTrustStoreListing, long refreshPeriod) throws Exception {
        ExtendedGSSContext gsscontext;
        X509Certificate[] certs = null;
        org.apache.axis.MessageContext axisMessageContext = (org.apache.axis.MessageContext)context;
        Set<Object> credset = peerSubject.getPublicCredentials();
        for (Object o : credset) {
            if (!(o instanceof X509Certificate[])) continue;
            certs = (X509Certificate[])o;
            break;
        }
        if (certs == null && (gsscontext = (ExtendedGSSContext)axisMessageContext.getProperty("org.globus.security.transport.context")) != null) {
            Object o;
            try {
                o = gsscontext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
            }
            catch (GSSException e) {
                String msg = "Cannot get peerSubject credentials";
                logger.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
            if (o instanceof X509Certificate[]) {
                certs = (X509Certificate[])o;
            }
        }
        if (certs == null) {
            String msg = "Cannot get peerSubject credentials";
            logger.error((Object)msg);
            throw new Exception(msg);
        }
        this.extractVOMSAttributes(certs, defaultTrustStoreListing, refreshPeriod);
    }

    private void init(ExtendedGSSCredential cred, String defaultTrustStoreListing, long refreshPeriod) throws GSSException, CertificateException, Exception {
        byte[] array = cred.export(0);
        ByteArrayInputStream byteArray = new ByteArrayInputStream(array);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        X509Certificate c1 = (X509Certificate)cf.generateCertificate(byteArray);
        certs.add(c1);
        logger.debug((Object)("Added certificate to the chain for DN: " + c1.getSubjectDN().getName()));
        int red = -1;
        String keyStr = "";
        while ((red = byteArray.read()) != -1 && !(keyStr = keyStr + (char)red).endsWith("-----END RSA PRIVATE KEY-----")) {
        }
        byteArray.read();
        try {
            while (true) {
                X509Certificate cert = (X509Certificate)cf.generateCertificate(byteArray);
                certs.add(cert);
                logger.debug((Object)("Added certificate to the chain for DN: " + cert.getSubjectDN().getName()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Certificate chain is composed by " + certs.size() + " certificates\n"));
            this.extractVOMSAttributes(certs.toArray(new X509Certificate[certs.size()]), defaultTrustStoreListing, refreshPeriod);
            return;
        }
    }

    public String[] getRoles(String group) {
        HashSet<String> roles = new HashSet<String>();
        for (int i = 0; i < this.vomsAttributes.length; ++i) {
            List listFQAN = this.vomsAttributes[i].getFullyQualifiedAttributes();
            if (listFQAN.isEmpty()) continue;
            Iterator it = listFQAN.iterator();
            while (it.hasNext()) {
                FQAN fqan = new FQAN((String)it.next());
                String fqanGroup = fqan.getGroup();
                if (!fqanGroup.equals(group) || fqan.getRole().equals("NULL")) continue;
                roles.add(fqan.getRole());
            }
        }
        return roles.toArray(new String[0]);
    }

    public String getParentGroup(String group) {
        return group.substring(0, group.lastIndexOf("/"));
    }

    public String[] getChildGroups(String group) {
        String[] vo = null;
        Vector<String> selectedVo = new Vector<String>();
        String root = this.getRootGroup(group);
        vo = this.getGroups(root);
        int j = 0;
        for (int i = 0; i < vo.length; ++i) {
            if (!vo[i].matches(group + "/[^/]+")) continue;
            selectedVo.add(vo[i]);
            ++j;
        }
        return selectedVo.toArray(new String[0]);
    }

    public boolean hasRole(String role, String group) {
        boolean hasRole = false;
        for (int i = 0; i < this.vomsAttributes.length; ++i) {
            List listFQAN = this.vomsAttributes[i].getFullyQualifiedAttributes();
            if (listFQAN.isEmpty()) continue;
            Iterator it = listFQAN.iterator();
            while (it.hasNext()) {
                FQAN fqan = new FQAN((String)it.next());
                String fqanGroup = fqan.getGroup();
                String fqanRole = fqan.getRole();
                if (!fqanGroup.equals(group) || !fqanRole.equals(role)) continue;
                hasRole = true;
            }
        }
        return hasRole;
    }

    public String[] getGroups() {
        HashSet<String> groups = new HashSet<String>();
        for (int i = 0; i < this.vomsAttributes.length; ++i) {
            List listFQAN = this.vomsAttributes[i].getFullyQualifiedAttributes();
            if (listFQAN.isEmpty()) continue;
            Iterator it = listFQAN.iterator();
            while (it.hasNext()) {
                FQAN fqan = new FQAN((String)it.next());
                groups.add(fqan.getGroup());
            }
        }
        return groups.toArray(new String[0]);
    }

    public String[] getGroups(String vo) {
        HashSet<String> groups = new HashSet<String>();
        for (int i = 0; i < this.vomsAttributes.length; ++i) {
            List listFQAN;
            if (!this.vomsAttributes[i].getVO().equals(vo) || (listFQAN = this.vomsAttributes[i].getFullyQualifiedAttributes()).isEmpty()) continue;
            Iterator it = listFQAN.iterator();
            while (it.hasNext()) {
                FQAN fqan = new FQAN((String)it.next());
                groups.add(fqan.getGroup());
            }
        }
        return groups.toArray(new String[0]);
    }

    public String[] getAbsoluteDLNames() {
        HashSet<String> dls = new HashSet<String>();
        for (int i = 0; i < this.vomsAttributes.length; ++i) {
            List listFQAN = this.vomsAttributes[i].getFullyQualifiedAttributes();
            if (listFQAN.isEmpty()) continue;
            Iterator it = listFQAN.iterator();
            while (it.hasNext()) {
                FQAN fqan = new FQAN((String)it.next());
                dls.add(fqan.getGroup());
            }
        }
        return dls.toArray(new String[0]);
    }

    public String[] getGroupsNames(String vo) {
        HashSet<String> groups = new HashSet<String>();
        for (int i = 0; i < this.vomsAttributes.length; ++i) {
            List listFQAN;
            if (!this.vomsAttributes[i].getVO().equals(vo) || (listFQAN = this.vomsAttributes[i].getFullyQualifiedAttributes()).isEmpty()) continue;
            Iterator it = listFQAN.iterator();
            while (it.hasNext()) {
                FQAN fqan = new FQAN((String)it.next());
                groups.add(fqan.getGroup());
            }
        }
        return groups.toArray(new String[0]);
    }

    public String[] getVONames() {
        HashSet<String> voNames = new HashSet<String>();
        for (int i = 0; i < this.vomsAttributes.length; ++i) {
            voNames.add(this.vomsAttributes[i].getVO());
        }
        return voNames.toArray(new String[0]);
    }

    public String[] getRootGroups() {
        HashSet<String> voNames = new HashSet<String>();
        for (int i = 0; i < this.vomsAttributes.length; ++i) {
            voNames.add("/" + this.vomsAttributes[i].getVO());
        }
        return voNames.toArray(new String[0]);
    }

    private String getRootGroup(String group) {
        if (group.lastIndexOf("/") != 0) {
            String modGroup = group.substring(1);
            return modGroup.substring(0, modGroup.indexOf("/"));
        }
        return group.substring(1);
    }

    public String getAbsoluteDLName() {
        String[] dls = this.getAbsoluteDLNames();
        String runningVO = "";
        for (int i = 0; i < dls.length; ++i) {
            if (this.getRoles(dls[i]).length == 0) continue;
            runningVO = dls[i];
            break;
        }
        return runningVO;
    }

    public String[] getLocalDLNames() {
        HashSet<String> dls = new HashSet<String>();
        for (int i = 0; i < this.vomsAttributes.length; ++i) {
            List listFQAN = this.vomsAttributes[i].getFullyQualifiedAttributes();
            if (listFQAN.isEmpty()) continue;
            Iterator it = listFQAN.iterator();
            while (it.hasNext()) {
                FQAN fqan = new FQAN((String)it.next());
                dls.add(this.getLocalGroupName(fqan.getGroup()));
            }
        }
        return dls.toArray(new String[0]);
    }

    public String getLocalDLName() {
        String[] dls = this.getAbsoluteDLNames();
        String runningVO = "";
        for (int i = 0; i < dls.length; ++i) {
            if (this.getRoles(dls[i]).length == 0) continue;
            runningVO = dls[i];
            break;
        }
        return this.getLocalGroupName(runningVO);
    }

    private String getLocalGroupName(String group) {
        return group.split("/")[group.split("/").length - 1];
    }

    public static String getDEFAULT_TRUST_STORE_LISTING() {
        return DEFAULT_TRUST_STORE_LISTING;
    }

    public static String getPROPERTIES_FILE() {
        return PROPERTIES_FILE;
    }

    public static long getREFRESH_PERIOD() {
        return 0L;
    }

    public String getDefaultTrustStoreListing() {
        return this.defaultTrustStoreListing;
    }

    public void setDefaultTrustStoreListing(String defaultTrustStoreListing) {
        this.defaultTrustStoreListing = defaultTrustStoreListing;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setRefreshPeriod(long refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
    }

    public VOMSValidator getValidator() {
        return this.validator;
    }

    public void setValidator(VOMSValidator validator) {
        this.validator = validator;
    }
}

