/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.impl;

import com.sun.jersey.core.util.Base64;
import it.eng.rdlab.soa3.connector.beans.UserBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.soa3.connector.Authenticate;

public class ServiceDNAuthentication
implements Authenticate {
    private final String XPATH_STRING = "$resource/Profile/GHNDescription/SecurityData/CredentialsDistinguishedName/text()";
    private final String RESULT_TYPE = "$resource/Profile";
    private final String GHN_PREFIX = "GHN";
    private Log logger = LogFactory.getLog(this.getClass());
    private String scope = null;

    public ServiceDNAuthentication(String scope) {
        this.scope = scope;
    }

    @Override
    public void setSoa3Endpoint(String soa3Endpoint) {
    }

    @Override
    public UserBean authenticate(String parameter, String organization) {
        this.logger.debug((Object)"Using information system client");
        this.logger.debug((Object)("For scope " + this.scope));
        ScopeProvider.instance.set(this.scope);
        String decodedDN = Base64.base64Decode((String)parameter);
        XQuery query = ICFactory.queryFor(HostingNode.class);
        StringBuilder xpathStringBuilder = new StringBuilder("$resource/Profile/GHNDescription/SecurityData/CredentialsDistinguishedName/text()");
        xpathStringBuilder.append(" eq ").append("\"").append(decodedDN).append("\"");
        this.logger.debug((Object)("Query string " + xpathStringBuilder));
        query.addCondition(xpathStringBuilder.toString()).setResult("$resource/Profile");
        this.logger.debug((Object)"Loading discovery client...");
        DiscoveryClient client = ICFactory.clientFor(HostingNode.Profile.class);
        UserBean responseBean = null;
        try {
            List profiles = client.submit((Query)query);
            this.logger.debug((Object)"Query performed");
            if (profiles != null && profiles.size() > 0) {
                if (profiles.size() > 1) {
                    this.logger.warn((Object)("Found " + profiles.size() + " entries: only the first one will be used"));
                }
                HostingNode.Profile profile = (HostingNode.Profile)profiles.get(0);
                this.logger.debug((Object)"Received profile ");
                this.logger.debug((Object)profile);
                responseBean = new UserBean();
                HostingNode.Profile.NodeDescription description = profile.description();
                this.logger.debug((Object)("Description: " + description));
                ArrayList<String> roles = new ArrayList<String>();
                if (description != null) {
                    String name = description.name();
                    this.logger.debug((Object)("Name " + name));
                    responseBean.setUserName(name);
                    roles.add("GHN." + profile.description().name());
                }
                HostingNode.Profile.Site site = profile.site();
                this.logger.debug((Object)("Site: " + site));
                if (site != null) {
                    String country = site.country();
                    String domain = site.domain();
                    String location = site.location();
                    this.logger.debug((Object)("Country " + country));
                    this.logger.debug((Object)("Domain " + domain));
                    this.logger.debug((Object)("Location " + location));
                    roles.add("GHN." + profile.site().country());
                    roles.add("GHN." + profile.site().domain());
                    roles.add("GHN." + profile.site().location());
                }
                roles.add(decodedDN);
                this.logger.debug((Object)("Profile attributes " + roles));
                responseBean.setRoles(roles);
            } else {
                this.logger.debug((Object)"Node not found");
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"Exception in sending IS query", (Throwable)e);
        }
        return responseBean;
    }
}

