/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.impl;

import it.eng.rdlab.soa3.connector.beans.PolicyRequestBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.Authorize;
import org.gcube.soa3.connector.rest.RestManager;

public class PolicyManagerBasedAuthorization
implements Authorize {
    private String soa3Endpoint;
    private Log logger = LogFactory.getLog(this.getClass());
    private final String AUTHORIZATION_PATH = "policyService/policyquery";

    public PolicyManagerBasedAuthorization(String soa3Endpoint) {
        this.soa3Endpoint = soa3Endpoint;
    }

    @Override
    public boolean authorize(Map<String, List<String>> attributes, String action, String resource) {
        this.logger.debug((Object)("Loading REST manager for " + this.soa3Endpoint));
        RestManager manager = RestManager.getInstance(this.soa3Endpoint);
        this.logger.debug((Object)"REST manager loaded");
        PolicyRequestBean bean = new PolicyRequestBean();
        bean.setAttributes(this.generateAttributeList(attributes));
        bean.setAction(action);
        bean.setResource(resource);
        int responseCode = manager.sendPostMessage("policyService/policyquery", new HashMap<String, String>(), bean, MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_PLAIN_TYPE);
        this.logger.debug((Object)("Response code " + responseCode));
        return responseCode >= 200 && responseCode < 300;
    }

    @Override
    public void setSoa3Endpoint(String soa3Endpoint) {
        this.soa3Endpoint = soa3Endpoint;
    }

    private List<String> generateAttributeList(Map<String, List<String>> attributesMap) {
        this.logger.debug((Object)"Converting attributes map");
        Iterator<String> keys = attributesMap.keySet().iterator();
        ArrayList<String> response = new ArrayList<String>();
        while (keys.hasNext()) {
            String key = keys.next();
            this.logger.debug((Object)("Key = " + key));
            List<String> values = attributesMap.get(key);
            for (String value : values) {
                this.logger.debug((Object)("Value = " + value));
                response.add(key + "=" + value);
            }
        }
        this.logger.debug((Object)("Added " + response.size() + " attributes"));
        return response;
    }
}

