/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.impl;

import it.eng.rdlab.soa3.connector.beans.SessionBean;
import it.eng.rdlab.soa3.connector.beans.SessionBeanResponse;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.rest.RestManager;

public class SessionAuthentication {
    private static final String METHOD = "SES";
    private static final String ENDPOINT_BASE_PATH = "soa3Service/access/session";
    private static final String HEADER = "Authorization";
    private Log logger = LogFactory.getLog(this.getClass());
    private String soa3Endpoint;

    public SessionAuthentication(String soa3Endpoint) {
        this.soa3Endpoint = soa3Endpoint;
    }

    public SessionBean getRemoteBean(String ticket) {
        this.logger.debug((Object)("Loading REST manager for " + this.soa3Endpoint));
        RestManager manager = RestManager.getInstance(this.soa3Endpoint);
        this.logger.debug((Object)"REST manager loaded");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER, "SES " + ticket);
        SessionBeanResponse sessionResponse = manager.sendMessage(ENDPOINT_BASE_PATH, headers, null, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE, SessionBeanResponse.class);
        int responseCode = sessionResponse.getResponseCode();
        this.logger.debug((Object)("Response code " + responseCode));
        SessionBean response = null;
        if (responseCode < 300 && responseCode >= 200 && sessionResponse.getResponse() != null) {
            response = sessionResponse.getResponse();
            this.logger.debug((Object)("Session end = " + response));
        } else {
            this.logger.debug((Object)"No session");
        }
        return response;
    }

    public void setSoa3Endpoint(String soa3Endpoint) {
        this.soa3Endpoint = soa3Endpoint;
    }
}

