/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.service.core.impl.authentication;

import it.eng.rdlab.soa3.connector.beans.UserBean;
import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;
import it.eng.rdlab.soa3.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.connector.service.core.AccessCache;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationInternalService;
import it.eng.rdlab.soa3.connector.service.core.IdentityControlManager;
import it.eng.rdlab.soa3.connector.service.core.TicketControlManager;
import it.eng.rdlab.soa3.connector.service.core.impl.authentication.AuthenticationInternalServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.Authenticate;
import org.gcube.soa3.connector.impl.ServiceDNAuthentication;
import org.gcube.soa3.connector.impl.UserDNAuthentication;

/*
 * Exception performing whole class analysis ignored.
 */
public class DNAuthenticationService
extends AuthenticationInternalServiceImpl
implements AuthenticationInternalService {
    private Log log = LogFactory.getLog(this.getClass());
    private String soa3Endpoint;
    private String defaultOrganization;
    private String scope;

    public DNAuthenticationService(String soa3Endpoint, String defaultOrganization, String scope) {
        super((AccessCache)IdentityControlManager.getInstance());
        this.soa3Endpoint = soa3Endpoint;
        this.defaultOrganization = defaultOrganization;
        this.scope = scope;
    }

    protected AccessControlBean askToSOA3(String id, long currentTime) {
        this.log.debug((Object)"entry not found, calling SOA3");
        this.log.debug((Object)"Looking if the DN is associated to a service");
        AccessControlBean bean = this.getAccessControlBean(id);
        if (bean != null) {
            this.log.debug((Object)"Authentication OK");
            bean.setSessionStart(currentTime);
            bean.setSessionEnd(currentTime + Configuration.getInstance().getAuthValidity());
            IdentityControlManager.getInstance().setAccessGrantEntry(id, bean);
            TicketControlManager.getInstance().setAccessGrantEntry(bean.getTicket(), bean);
            this.log.debug((Object)"Cache updated");
        } else {
            this.log.debug((Object)"Authentication failed: inserting new value in the black list");
            IdentityControlManager.getInstance().setAccessDeniedEntry(id, currentTime + Configuration.getInstance().getAuthValidity());
            this.log.debug((Object)"Black list updated");
        }
        return bean;
    }

    private AccessControlBean getAccessControlBean(String id) {
        this.log.debug((Object)("Loading access bean for " + id));
        AccessControlBean bean = this.performAuthentication((Authenticate)new ServiceDNAuthentication(this.scope), id);
        if (bean == null) {
            this.log.debug((Object)"DN not associated to a service: looking if the DN is associated to an user");
            bean = this.performAuthentication((Authenticate)new UserDNAuthentication(this.soa3Endpoint), id);
        }
        this.log.debug((Object)"Operation completed");
        return bean;
    }

    private AccessControlBean performAuthentication(Authenticate authenticationManager, String id) {
        UserBean response = authenticationManager.authenticate(id, this.defaultOrganization);
        AccessControlBean bean = null;
        if (response != null) {
            this.log.debug((Object)"Login ok, generating the access control bean");
            bean = new AccessControlBean();
            bean.setUsername(response.getUserName());
            if (response.getRoles() != null && response.getRoles().size() > 0) {
                this.log.debug((Object)"Loading roles from response");
                bean.setRolesLoaded(true);
                bean.getRoles().addAll(response.getRoles());
                this.log.debug((Object)"Roles loaded");
            }
            String ticket = DNAuthenticationService.generateTicket();
            this.log.debug((Object)("Ticket = " + ticket));
            bean.setTicket(ticket);
            this.log.debug((Object)"Access control bean added in the cache");
        } else {
            this.log.debug((Object)"DN not associated to any record");
        }
        return bean;
    }
}

