/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.service.core.impl.authentication;

import com.sun.jersey.core.util.Base64;
import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;
import it.eng.rdlab.soa3.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.connector.service.core.AccessCache;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationInternalService;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AuthenticationInternalServiceImpl
implements AuthenticationInternalService {
    private static Log log = LogFactory.getLog(AuthenticationInternalServiceImpl.class);
    private AccessCache accessCache;

    public AuthenticationInternalServiceImpl(AccessCache accessCache) {
        this.accessCache = accessCache;
    }

    public String authenticate(String id) {
        log.debug((Object)"Authenticating...");
        AccessControlBean accessBean = this.getAccessBean(id);
        if (accessBean == null) {
            log.debug((Object)"Access denied");
            return null;
        }
        String ticket = accessBean.getTicket();
        log.debug((Object)("Ticket = " + ticket));
        return ticket;
    }

    protected AccessControlBean getAccessBean(String id) {
        log.debug((Object)"Initialization");
        long currentTime = new Date().getTime();
        AccessControlBean responseBean = this.accessCache.getAccessGrantEntry(id);
        log.debug((Object)"Checking the cache");
        AccessControlBean response = null;
        if (responseBean != null) {
            if (!this.checkLocalCache(id, responseBean, currentTime)) {
                log.debug((Object)"Invalid authentication parameter found");
                response = null;
            } else {
                response = responseBean;
            }
        }
        if (response == null && !this.isInBlackList(id, currentTime)) {
            response = this.askToSOA3(id, currentTime);
        }
        log.debug((Object)"Operation completed");
        return response;
    }

    private boolean checkLocalCache(String id, AccessControlBean accessControlBean, long currentTime) {
        log.debug((Object)("Username = " + accessControlBean.getUsername()));
        long sessionEnd = accessControlBean.getSessionEnd();
        log.debug((Object)("Session end " + sessionEnd));
        boolean response = false;
        if (currentTime > sessionEnd) {
            log.debug((Object)"Login expired");
            this.accessCache.removeAccessGrantEntry(id);
        } else {
            log.debug((Object)"Entry found in the cache");
            response = true;
        }
        return response;
    }

    private boolean isInBlackList(String id, long currentTime) {
        log.debug((Object)"Checking access denied cache...");
        long blackListTime = this.accessCache.getAccessDeniedEntry(id);
        if (blackListTime > -1L && currentTime <= blackListTime) {
            log.debug((Object)"Access attempt in the blacklist");
            return true;
        }
        if (blackListTime != -1L) {
            this.accessCache.removeAccessDeniedEntry(id);
        }
        return false;
    }

    protected static String generateTicket() {
        String serviceName = Configuration.getInstance().getServiceName();
        log.debug((Object)("Service name = " + serviceName));
        StringBuilder builder = new StringBuilder(serviceName).append("::").append(UUID.randomUUID().toString());
        String response = new String(Base64.encode((byte[])builder.toString().getBytes()));
        log.debug((Object)("Complete ticket = " + response));
        return response;
    }

    protected abstract AccessControlBean askToSOA3(String var1, long var2);
}

