/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.service.jaxrs;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.core.HttpContext;
import it.eng.rdlab.soa3.connector.beans.SessionBean;
import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;
import it.eng.rdlab.soa3.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationInternalService;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationServiceFactory;
import it.eng.rdlab.soa3.connector.service.core.AuthorizationInternalService;
import it.eng.rdlab.soa3.connector.service.core.AuthorizationServiceFactory;
import it.eng.rdlab.soa3.connector.service.core.RolesLoaderFactory;
import it.eng.rdlab.soa3.connector.service.core.TicketControlManager;
import it.eng.rdlab.soa3.connector.service.core.impl.authentication.SessionAuthenticationService;
import it.eng.rdlab.soa3.connector.service.utils.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.gcube.soa3.connector.RolesLoader;

@Path(value="/access")
public class AccessService {
    private Log logger = LogFactory.getLog(this.getClass());
    private final String AUTHORIZATION_HEADER = "Authorization";
    private final String SERVICE_STRING_HEADER = "Servicestring";
    private final String SERVICE_INSTANCE_HEADER = "Serviceinstance";

    private String[] parseHeader(String authHeader) {
        String[] encodedHeader = authHeader.split(" ");
        if (encodedHeader.length < 2) {
            this.logger.error((Object)("invalid authorization header " + authHeader));
            throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)("Invalid authorization header " + authHeader)).build());
        }
        return encodedHeader;
    }

    @GET
    @Produces(value={"application/json"})
    public String getAccessControl(@Context HttpContext context) {
        this.logger.debug((Object)"Checking access privileges");
        String authHeader = context.getRequest().getHeaderValue("Authorization");
        String serviceString = context.getRequest().getHeaderValue("Servicestring");
        String serviceInstance = context.getRequest().getHeaderValue("Serviceinstance");
        this.logger.debug((Object)("Authentication header " + authHeader));
        this.logger.debug((Object)("Service string header " + serviceString));
        this.logger.debug((Object)("Service instance header " + serviceInstance));
        String ticket = this.performAuthentication(authHeader);
        boolean authorizationEnabled = Configuration.getInstance().isAuthorizationEnabled();
        this.logger.debug((Object)("Authorization enabled " + authorizationEnabled));
        if (authorizationEnabled) {
            boolean authorized = this.performAuthorization(ticket, serviceString, serviceInstance);
            this.logger.debug((Object)("Authorized " + authorized));
            if (authorized) {
                return ticket;
            }
            throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)("Authorization failed for " + serviceString + " " + serviceInstance)).build());
        }
        this.logger.debug((Object)"Authorization disabled");
        return ticket;
    }

    @GET
    @Path(value="/session")
    @Produces(value={"application/json"})
    public Response getSession(@Context HttpContext context) {
        this.logger.debug((Object)"Checking access privileges");
        String authHeader = context.getRequest().getHeaderValue("Authorization");
        if (authHeader != null) {
            this.logger.debug((Object)"Parsing authN header");
            String[] encodedHeader = this.parseHeader(authHeader);
            this.logger.debug((Object)"Parsing authN header");
            this.logger.debug((Object)("Authentication type " + encodedHeader[0]));
            if (encodedHeader[0].equals("SES")) {
                this.logger.debug((Object)("Authentication data " + encodedHeader[1]));
                SessionAuthenticationService authenticationService = new SessionAuthenticationService(true);
                this.logger.debug((Object)"Calling the authentication service");
                SessionBean sessionBean = authenticationService.getSessionBean(encodedHeader[1]);
                if (sessionBean != null) {
                    this.logger.debug((Object)("Authentication OK, session " + sessionBean));
                    return this.generateResponse((Object)sessionBean);
                }
                this.logger.error((Object)"authentication unsuccessful");
                throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)"Wrong credentials, check username and password ").build());
            }
            this.logger.error((Object)"Invalid authentication header, only Session based authentication allowed");
            throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Invalid authentication header, only Session based authentication allowed").build());
        }
        this.logger.error((Object)"Invalid authentication header");
        throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"No authorization header found ").build());
    }

    private String performAuthentication(String authHeader) {
        this.logger.debug((Object)"Perform authentication");
        if (authHeader != null) {
            this.logger.debug((Object)"Parsing authN header");
            String[] encodedHeader = this.parseHeader(authHeader);
            this.logger.debug((Object)"Parsing authN header");
            this.logger.debug((Object)("Authentication type " + encodedHeader[0]));
            this.logger.debug((Object)("Authentication data " + encodedHeader[1]));
            HashMap<String, String> authenticationServiceRequestParameters = new HashMap<String, String>();
            authenticationServiceRequestParameters.put(AuthenticationServiceFactory.REQUEST_HEADER, encodedHeader[0]);
            AuthenticationInternalService authenticationService = AuthenticationServiceFactory.generateService(authenticationServiceRequestParameters);
            if (authenticationService == null) {
                this.logger.error((Object)("invalid authorization header " + encodedHeader[0]));
                throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)("Invalid authorization header " + encodedHeader[0])).build());
            }
            this.logger.debug((Object)"Calling the authentication service");
            String ticket = authenticationService.authenticate(encodedHeader[1]);
            if (ticket != null) {
                this.logger.debug((Object)("Authentication OK, ticket " + ticket));
                return ticket;
            }
            this.logger.error((Object)"authentication unsuccessful");
            throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)"Wrong credentials").build());
        }
        this.logger.error((Object)"Invalid authentication header");
        throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"No authorization header found ").build());
    }

    private boolean performAuthorization(String ticket, String action, String resource) {
        this.logger.debug((Object)"Perform authorization");
        boolean response = false;
        AccessControlBean bean = TicketControlManager.getInstance().getAccessGrantEntry(ticket);
        try {
            if (!bean.isRolesLoaded()) {
                this.logger.debug((Object)"Loading roles");
                RolesLoader rolesLoader = RolesLoaderFactory.getRoleLoader();
                List roles = rolesLoader.loadRoles(bean.getUsername(), Configuration.getInstance().getDefaultOrganization());
                bean.setRolesLoaded(true);
                if (roles != null && roles.size() > 0) {
                    this.logger.debug((Object)"Importing roles");
                    bean.getRoles().addAll(roles);
                    this.logger.debug((Object)"Roles imported");
                } else {
                    this.logger.debug((Object)"No roles found");
                }
            }
            if (bean.getRoles().size() > 0) {
                this.logger.debug((Object)"Performing authorization...");
                AuthorizationInternalService authorization = AuthorizationServiceFactory.generateService();
                response = authorization.authorize(ticket, action, resource);
                this.logger.debug((Object)"Authorization performed");
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"Inconsistent entries", (Throwable)e);
            response = false;
        }
        this.logger.debug((Object)("Response " + response));
        return response;
    }

    private Response generateResponse(Object responseObject) {
        String value = null;
        try {
            value = Utils.getMapper().writeValueAsString(responseObject);
            this.logger.debug((Object)("Response " + value));
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)value).build();
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get user unsuccessful due to json parse error  ");
            value = "json mapping error";
        }
        catch (IOException e) {
            this.logger.error((Object)"get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)value).build());
    }
}

