/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.service.core.impl.authentication;

import com.sun.jersey.core.util.Base64;
import it.eng.rdlab.soa3.connector.beans.SessionBean;
import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;
import it.eng.rdlab.soa3.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.connector.service.core.AccessCache;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationInternalService;
import it.eng.rdlab.soa3.connector.service.core.TicketControlManager;
import it.eng.rdlab.soa3.connector.service.core.impl.authentication.AuthenticationInternalServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.impl.SessionAuthentication;

public class SessionAuthenticationService
extends AuthenticationInternalServiceImpl
implements AuthenticationInternalService {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean local;

    public SessionAuthenticationService(boolean local) {
        super((AccessCache)TicketControlManager.getInstance());
        this.local = local;
    }

    public SessionAuthenticationService() {
        this(false);
    }

    protected AccessControlBean askToSOA3(String id, long currentTime) {
        if (!this.local) {
            this.log.debug((Object)"Ticket not found in the internal cache");
            this.log.debug((Object)"Parsing the ticket...");
            try {
                String[] decodedTicket = Base64.base64Decode((String)id).split("::");
                String ticketServiceName = decodedTicket[0].trim();
                String serviceName = Configuration.getInstance().getServiceName();
                this.log.debug((Object)("Requested soa3 instance " + ticketServiceName));
                this.log.debug((Object)("Current service instance " + serviceName));
                if (serviceName.equalsIgnoreCase(ticketServiceName)) {
                    this.log.error((Object)"Ticket is for this service but is not found in the cache: authentication error");
                    this.log.debug((Object)"Authentication failed: inserting new value in the black list");
                    TicketControlManager.getInstance().setAccessDeniedEntry(id, currentTime + Configuration.getInstance().getAuthValidity());
                    this.log.debug((Object)"Black list updated");
                    return null;
                }
                String serviceUrl = Configuration.getInstance().getService(ticketServiceName);
                if (serviceUrl == null) {
                    this.log.error((Object)"Service url not found");
                    this.log.debug((Object)"Authentication failed: inserting new value in the black list");
                    TicketControlManager.getInstance().setAccessDeniedEntry(id, currentTime + Configuration.getInstance().getAuthValidity());
                    this.log.debug((Object)"Black list updated");
                    return null;
                }
                this.log.debug((Object)("Calling " + serviceUrl));
                SessionAuthentication soa3Authentication = new SessionAuthentication(serviceUrl);
                SessionBean response = soa3Authentication.getRemoteBean(id);
                if (response == null) {
                    this.log.error((Object)"Ticket not found");
                    this.log.debug((Object)"Authentication failed: inserting new value in the black list");
                    TicketControlManager.getInstance().setAccessDeniedEntry(id, currentTime + Configuration.getInstance().getAuthValidity());
                    this.log.debug((Object)"Black list updated");
                    return null;
                }
                this.log.debug((Object)("Session expires on " + response));
                AccessControlBean bean = new AccessControlBean();
                bean.setTicket(id);
                bean.setSessionStart(Long.parseLong(response.getSessionStart()));
                bean.setSessionEnd(Long.parseLong(response.getSessionEnd()));
                bean.setUsername(response.getUserId());
                if (response.getRoles().size() > 0) {
                    this.log.debug((Object)"Loading roles from response");
                    bean.setRolesLoaded(true);
                    bean.getRoles().addAll(response.getRoles());
                    this.log.debug((Object)"Roles loaded");
                }
                TicketControlManager.getInstance().setAccessGrantEntry(id, bean);
                return bean;
            }
            catch (RuntimeException e) {
                this.log.error((Object)"Unable to determine the ticket", (Throwable)e);
                this.log.debug((Object)"Authentication failed: inserting new value in the black list");
                TicketControlManager.getInstance().setAccessDeniedEntry(id, currentTime + Configuration.getInstance().getAuthValidity());
                this.log.debug((Object)"Black list updated");
                return null;
            }
        }
        this.log.debug((Object)"external request disabled");
        return null;
    }

    public SessionBean getSessionBean(String id) {
        this.log.debug((Object)"Getting the end of the session");
        AccessControlBean accessBean = this.getAccessBean(id);
        if (accessBean == null) {
            this.log.debug((Object)"No session");
            return null;
        }
        SessionBean sessionBean = new SessionBean();
        sessionBean.setUserId(accessBean.getUsername());
        sessionBean.setRoles(accessBean.getRoles());
        sessionBean.setSessionStart(String.valueOf(accessBean.getSessionStart()));
        sessionBean.setSessionEnd(String.valueOf(accessBean.getSessionEnd()));
        this.log.debug((Object)("Session = " + sessionBean));
        return sessionBean;
    }
}

