/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.service.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccessControlBean {
    private String username;
    private String ticket;
    private long sessionStart;
    private long sessionEnd;
    private Map<String, List<String>> permittedOperations = new HashMap();
    private Map<String, List<String>> deniedOperations = new HashMap();
    private List<String> roles = new ArrayList();
    private boolean rolesLoaded = false;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    public void setSessionStart(long sessionStart) {
        this.sessionStart = sessionStart;
    }

    public long getSessionEnd() {
        return this.sessionEnd;
    }

    public void setSessionEnd(long sessionEnd) {
        this.sessionEnd = sessionEnd;
    }

    public void addPermittedOperation(String service, String operation) {
        ArrayList<String> operationList = (ArrayList<String>)this.permittedOperations.get(service);
        if (operationList == null) {
            operationList = new ArrayList<String>();
            this.permittedOperations.put(service, operationList);
        }
        operationList.add(operation);
    }

    public void addDeniedOperation(String service, String operation) {
        ArrayList<String> operationList = (ArrayList<String>)this.deniedOperations.get(service);
        if (operationList == null) {
            operationList = new ArrayList<String>();
            this.deniedOperations.put(service, operationList);
        }
        operationList.add(operation);
    }

    public boolean isPermitted(String service, String operation) {
        List operations = (List)this.permittedOperations.get(service);
        if (operations == null) {
            return false;
        }
        return operations.contains(operation);
    }

    public boolean isDenied(String service, String operation) {
        List operations = (List)this.deniedOperations.get(service);
        if (operations == null) {
            return false;
        }
        return operations.contains(operation);
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean isRolesLoaded() {
        return this.rolesLoaded;
    }

    public void setRolesLoaded(boolean rolesLoaded) {
        this.rolesLoaded = rolesLoaded;
    }
}

