/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.service.core.impl.authorization;

import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;
import it.eng.rdlab.soa3.connector.service.core.AuthorizationInternalService;
import it.eng.rdlab.soa3.connector.service.core.TicketControlManager;
import java.util.HashMap;
import java.util.List;
import org.gcube.soa3.connector.impl.PolicyManagerBasedAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyBasedAuthorization
implements AuthorizationInternalService {
    private String soa3Endpoint;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public PolicyBasedAuthorization(String soa3Endpoint) {
        this.soa3Endpoint = soa3Endpoint;
    }

    public boolean authorize(String ticket, String action, String resource) {
        this.logger.debug("Checking the local cache for permitted or denied operations...");
        this.logger.debug("Action = " + action);
        this.logger.debug("Resource = " + resource);
        boolean response = false;
        AccessControlBean accessBean = TicketControlManager.getInstance().getAccessGrantEntry(ticket);
        try {
            response = this.performAuthorization(accessBean, action, resource);
        }
        catch (RuntimeException e) {
            this.logger.error("Unable to find the entry", (Throwable)e);
            response = false;
        }
        this.logger.debug("Response = " + response);
        return response;
    }

    private boolean performAuthorization(AccessControlBean accessBean, String action, String resource) {
        this.logger.debug("Performing authorization...");
        boolean response = false;
        if (accessBean.isPermitted(action, resource)) {
            this.logger.debug("Operation permitted");
            response = true;
        } else if (accessBean.isDenied(action, resource)) {
            this.logger.debug("Operation denied");
            response = false;
        } else {
            this.logger.debug("Operation not present: asking soa3");
            List roles = accessBean.getRoles();
            HashMap<String, List> attributes = new HashMap<String, List>();
            attributes.put("role", roles);
            PolicyManagerBasedAuthorization policyManager = new PolicyManagerBasedAuthorization(this.soa3Endpoint);
            response = policyManager.authorize(attributes, action, resource);
            this.logger.debug("Response = " + response);
            if (response) {
                this.logger.debug("Adding the action and operation to the cache in the permitted section");
                accessBean.addPermittedOperation(action, resource);
            } else {
                this.logger.debug("Adding the action and operation to the cache in the denied section");
                accessBean.addDeniedOperation(action, resource);
            }
            return response;
        }
        this.logger.debug("Response = " + resource);
        return response;
    }
}

