/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.service.configuration;

import it.eng.rdlab.soa3.connector.service.configuration.ConfigurationDefaults;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuration
implements ConfigurationDefaults {
    private static Configuration instance;
    private Properties genericProperties;
    private Properties defaultProperties;
    private Properties serviceUrlMap;
    private Log logger = LogFactory.getLog(this.getClass());
    private final String CONFIGURATION_ROOT = "CONFIGURATION_ROOT";
    private final String CONFIGURATION_FILE = "CONFIGURATION_FILE";
    private final String SERVICE_MAP_FILE = "SERVICE_MAP_FILE";
    private final String DEFAULT_PROP_FILE = "/it/eng/rdlab/soa3/connector/service/configuration/configuration.properties";
    private final String PROP_FILES = "/it/eng/rdlab/soa3/connector/service/configuration/configurationfiles.properties";

    private Configuration() {
        Properties files = this.getConfigurationFiles();
        String root = files.getProperty("CONFIGURATION_ROOT", "");
        String configurationFilePath = files.getProperty("CONFIGURATION_FILE", "");
        String serviceMapPath = files.getProperty("SERVICE_MAP_FILE", "");
        if (root != null && root.startsWith("$")) {
            root = System.getProperty(root.substring(1));
            this.logger.debug((Object)("Actual root " + root));
        }
        this.serviceUrlMap = this.defineServiceUrlMap(root, serviceMapPath);
        this.genericProperties = this.getPropertiesFromFile(root, configurationFilePath);
        this.defaultProperties = this.getDefaultProperties();
    }

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public long getAuthValidity() {
        return this.getLongProperty("AUTHENTICATION_SESSION", 5L) * 60000L;
    }

    public String getSoa3Endpoint() {
        return this.getStringProperty("SOA3_ENDPOINT", "http://localhost:8080");
    }

    public String getServiceName() {
        return this.getStringProperty("SERVICE_NAME", "soa3");
    }

    public String getCertFile() {
        return this.genericProperties.getProperty("CERT_FILE", "/etc/grid-security/hostcert.pem");
    }

    public String getKeyFile() {
        return this.genericProperties.getProperty("KEY_FILE", "/etc/grid-security/hostkey.pem");
    }

    public String getTrustDir() {
        return this.genericProperties.getProperty("TRUST_DIR", "/etc/grid-security/certificates/");
    }

    public String getTrustExt() {
        return this.genericProperties.getProperty("TRUST_FILE_EXTENSION", ".0");
    }

    public String getService(String serviceName) {
        return this.serviceUrlMap.getProperty(serviceName);
    }

    public boolean isAuthorizationEnabled() {
        return this.getBooleanProperty("AUTHORIZATION_ENABLED", true);
    }

    public String getDefaultOrganization() {
        return this.getStringProperty("DEFAULT_ORGANIZATION", "imarine");
    }

    public String getGCubeScope() {
        return this.getStringProperty("GCUBE_SCOPE", "/testing");
    }

    private Properties getPropertiesFromFile(String root, String configurationFilePath) {
        String path = root + configurationFilePath;
        this.logger.debug((Object)("Loading properties from " + path));
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(path));
            this.logger.debug((Object)"Operation completed");
        }
        catch (Exception e) {
            this.logger.warn((Object)"Configuration file not found", (Throwable)e);
        }
        return properties;
    }

    private Properties getDefaultProperties() {
        this.logger.debug((Object)"Loading default properties file");
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream("/it/eng/rdlab/soa3/connector/service/configuration/configuration.properties"));
        }
        catch (IOException e) {
            this.logger.error((Object)"Unable to find properties from the classpath", (Throwable)e);
        }
        return properties;
    }

    private Properties getConfigurationFiles() {
        Properties fileProperties = new Properties();
        try {
            fileProperties.load(this.getClass().getResourceAsStream("/it/eng/rdlab/soa3/connector/service/configuration/configurationfiles.properties"));
        }
        catch (IOException e1) {
            this.logger.error((Object)"Unable to find properties from the classpath", (Throwable)e1);
        }
        return fileProperties;
    }

    private Properties defineServiceUrlMap(String root, String path) {
        this.logger.debug((Object)"Loading service urls");
        String serviceMapFile = root + path;
        Properties response = new Properties();
        try {
            response.load(new FileInputStream(serviceMapFile));
            this.logger.debug((Object)"Service map loaded");
        }
        catch (Exception e) {
            this.logger.debug((Object)"No service map found");
        }
        this.logger.debug((Object)"Operation completed");
        return response;
    }

    private long getLongProperty(String key, long defaultValue) {
        long result = -1L;
        try {
            String stringValue = this.genericProperties.getProperty(key, this.defaultProperties.getProperty(key));
            result = stringValue == null ? defaultValue : Long.parseLong(stringValue);
        }
        catch (Exception e) {
            this.logger.error((Object)"Invalid value, using default");
            result = defaultValue;
        }
        return result;
    }

    private String getStringProperty(String key, String defaultValue) {
        return this.genericProperties.getProperty(key, this.defaultProperties.getProperty(key, defaultValue));
    }

    private boolean getBooleanProperty(String key, boolean defaultValue) {
        boolean result = false;
        try {
            String stringValue = this.genericProperties.getProperty(key, this.defaultProperties.getProperty(key));
            result = stringValue == null ? defaultValue : Boolean.parseBoolean(stringValue);
        }
        catch (Exception e) {
            this.logger.error((Object)"Invalid value, using default");
            result = defaultValue;
        }
        return result;
    }
}

