/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.service.core.impl.authentication;

import it.eng.rdlab.soa3.connector.beans.UserBean;
import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;
import it.eng.rdlab.soa3.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.connector.service.core.AccessCache;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationInternalService;
import it.eng.rdlab.soa3.connector.service.core.IdentityControlManager;
import it.eng.rdlab.soa3.connector.service.core.TicketControlManager;
import it.eng.rdlab.soa3.connector.service.core.impl.authentication.AuthenticationInternalServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.impl.UsernamePasswordAuthentication;

/*
 * Exception performing whole class analysis ignored.
 */
public class UsernamePasswordAuthenticationService
extends AuthenticationInternalServiceImpl
implements AuthenticationInternalService {
    private Log log = LogFactory.getLog(this.getClass());
    private String soa3Endpoint;
    private String defaultOrganization;

    public UsernamePasswordAuthenticationService(String soa3Endpoint, String defaultOrganization) {
        super((AccessCache)IdentityControlManager.getInstance());
        this.soa3Endpoint = soa3Endpoint;
        this.defaultOrganization = defaultOrganization;
    }

    protected AccessControlBean askToSOA3(String id, long currentTime) {
        this.log.debug((Object)"entry not found, calling SOA3");
        UsernamePasswordAuthentication soa3Authentication = new UsernamePasswordAuthentication(this.soa3Endpoint);
        UserBean response = soa3Authentication.authenticate(id, this.defaultOrganization);
        AccessControlBean bean = null;
        if (response != null) {
            this.log.debug((Object)"Login ok, generating the access control bean");
            bean = new AccessControlBean();
            bean.setUsername(response.getUserName());
            bean.setSessionStart(currentTime);
            bean.setSessionEnd(currentTime + Configuration.getInstance().getAuthValidity());
            List roles = response.getRoles();
            this.removeInvalidRoles(roles);
            if (roles.size() > 0) {
                this.log.debug((Object)"trying to load roles from response");
                bean.setRolesLoaded(true);
                bean.getRoles().addAll(response.getRoles());
                this.log.debug((Object)"Roles loaded");
            } else {
                this.log.debug((Object)"No roles found in the response");
            }
            String ticket = UsernamePasswordAuthenticationService.generateTicket();
            this.log.debug((Object)("Ticket = " + ticket));
            bean.setTicket(ticket);
            IdentityControlManager.getInstance().setAccessGrantEntry(id, bean);
            TicketControlManager.getInstance().setAccessGrantEntry(ticket, bean);
            this.log.debug((Object)"Access control bean added in the cache");
        } else {
            this.log.debug((Object)"Authentication failed: inserting new value in the black list");
            IdentityControlManager.getInstance().setAccessDeniedEntry(id, currentTime + Configuration.getInstance().getAuthValidity());
            this.log.debug((Object)"Black list updated");
        }
        return bean;
    }

    private void removeInvalidRoles(List<String> roles) {
        if (roles != null) {
            this.log.debug((Object)"Checking for invalid roles");
            ArrayList<String> internalRoles = new ArrayList<String>(roles);
            for (String ir : internalRoles) {
                if (ir.trim().length() != 0) continue;
                this.log.debug((Object)"Found invalid role");
                roles.remove(ir);
            }
        }
    }
}

