/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.service.core.impl.authentication;

import it.eng.rdlab.soa3.connector.beans.UserBean;
import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;
import it.eng.rdlab.soa3.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.connector.service.core.AccessCache;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationInternalService;
import it.eng.rdlab.soa3.connector.service.core.IdentityControlManager;
import it.eng.rdlab.soa3.connector.service.core.TicketControlManager;
import it.eng.rdlab.soa3.connector.service.core.impl.authentication.AuthenticationInternalServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.impl.FederatedAuthentication;

/*
 * Exception performing whole class analysis ignored.
 */
public class FederatedAuthenticationService
extends AuthenticationInternalServiceImpl
implements AuthenticationInternalService {
    private Log log;
    private String soa3Endpoint;

    public FederatedAuthenticationService(String soa3Endpoint) {
        super((AccessCache)IdentityControlManager.getInstance());
        this.soa3Endpoint = soa3Endpoint;
        this.log = LogFactory.getLog(this.getClass());
    }

    protected AccessControlBean askToSOA3(String id, long currentTime) {
        this.log.debug((Object)"entry not found, calling SOA3");
        FederatedAuthentication soa3Authentication = new FederatedAuthentication(this.soa3Endpoint);
        UserBean response = soa3Authentication.authenticate(id, null);
        AccessControlBean bean = null;
        if (response != null) {
            this.log.debug((Object)"Login ok, generating the access control bean");
            bean = new AccessControlBean();
            bean.setUsername(response.getUserName());
            bean.setSessionStart(currentTime);
            bean.setSessionEnd(currentTime + Configuration.getInstance().getAuthValidity());
            this.log.debug((Object)"Loading federated roles...");
            bean.setRolesLoaded(true);
            bean.getRoles().addAll(response.getRoles());
            this.log.debug((Object)"Roles loaded");
            String ticket = FederatedAuthenticationService.generateTicket();
            this.log.debug((Object)("Ticket = " + ticket));
            bean.setTicket(ticket);
            IdentityControlManager.getInstance().setAccessGrantEntry(id, bean);
            TicketControlManager.getInstance().setAccessGrantEntry(ticket, bean);
            this.log.debug((Object)"Access control bean added in the cache");
        } else {
            this.log.debug((Object)"Authentication failed: inserting new value in the black list");
            IdentityControlManager.getInstance().setAccessDeniedEntry(id, currentTime + Configuration.getInstance().getAuthValidity());
            this.log.debug((Object)"Black list updated");
        }
        return bean;
    }
}

