/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.connector.service.core;

import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;
import it.eng.rdlab.soa3.connector.service.core.AccessCache;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class AccessControlManager
implements AccessCache {
    private Map<String, AccessControlBean> accessControlMap = Collections.synchronizedMap(new WeakHashMap());
    private Map<String, Long> accessDeniedMap = Collections.synchronizedMap(new WeakHashMap());

    protected AccessControlManager() {
    }

    public synchronized AccessControlBean getAccessGrantEntry(String id) {
        return (AccessControlBean)this.accessControlMap.get(id);
    }

    public synchronized void removeAccessGrantEntry(String id) {
        this.accessControlMap.remove(id);
    }

    public synchronized void setAccessGrantEntry(String id, AccessControlBean bean) {
        this.accessControlMap.put(id, bean);
    }

    public synchronized long getAccessDeniedEntry(String id) {
        Long accessDeniedExpiration = (Long)this.accessDeniedMap.get(id);
        if (accessDeniedExpiration == null) {
            accessDeniedExpiration = -1L;
        }
        return accessDeniedExpiration;
    }

    public synchronized void removeAccessDeniedEntry(String id) {
        this.accessDeniedMap.remove(id);
    }

    public synchronized void setAccessDeniedEntry(String id, long accessDeniedExpiration) {
        this.accessDeniedMap.put(id, accessDeniedExpiration);
    }
}

