/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.um.rest.jaxrs;

import com.sun.jersey.api.core.HttpContext;
import it.eng.rdlab.soa3.um.rest.bean.GroupModel;
import it.eng.rdlab.soa3.um.rest.conf.ConfigurationManager;
import it.eng.rdlab.soa3.um.rest.exceptions.UMJSONParserException;
import it.eng.rdlab.soa3.um.rest.impl.GroupManagerImpl;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.GroupJaxbBean;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.GroupsJaxbBean;
import it.eng.rdlab.soa3.um.rest.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

@Path(value="/groupmanager")
public class GroupManager {
    private GroupManagerImpl groupManager;
    private ConfigurationManager cm;
    private Log logger = LogFactory.getLog(this.getClass());

    public GroupManager() throws Exception {
        this.cm = ConfigurationManager.getInstance();
        this.groupManager = new GroupManagerImpl(ConfigurationManager.getInstance().getLdapUrl());
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response createGroup(GroupJaxbBean groupBean, @Context HttpContext context) {
        String description;
        String organizationName;
        String groupName = groupBean.getGroupName();
        String groupNameMng = this.groupManager.createGroup(groupName, organizationName = groupBean.getOrganizationName(), description = groupBean.getDescription(), this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        if (groupNameMng == null) {
            this.logger.error((Object)("Group was not created" + groupName));
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Group  " + groupName + " was not created")).build());
        }
        this.logger.debug((Object)("Group has been created successfully " + groupName));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Group has been created successfully ").build();
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/{groupName}/organization/{organizationName}")
    public Response getGroup(@PathParam(value="groupName") String groupName, @PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        this.logger.debug((Object)("Getting group " + groupName));
        GroupModel group = this.groupManager.getGroup(groupName, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        if (group == null) {
            this.logger.error((Object)("Group " + groupName + " doesn't exist"));
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Group " + groupName + " doesn't exist")).build());
        }
        this.logger.debug((Object)("Group has been created successfully " + groupName));
        try {
            String value = Utils.getMapper().writeValueAsString((Object)new GroupJaxbBean(group.getGroupName(), organizationName, group.getDescription()));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)value).build();
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get group unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to generate JSON ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get group unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to map JSON ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"get group unsuccessful due to json parse error  ");
            throw new UMJSONParserException("IO Exception while parsing JSON ", (Throwable)e);
        }
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/{groupName}")
    public Response getGroup(@PathParam(value="groupName") String groupName, @Context HttpContext context) {
        return this.getGroup(groupName, null, context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/groups/{organizationName}")
    @Produces(value={"application/json"})
    public String listGroups(@PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        List groups = this.groupManager.listGroupsByOrganization(organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        Iterator groupsIter = groups.iterator();
        ArrayList<String> groupNames = new ArrayList<String>();
        while (groupsIter.hasNext()) {
            groupNames.add(((GroupModel)groupsIter.next()).getGroupName());
        }
        if (groupNames.isEmpty()) {
            this.logger.error((Object)(" Organization " + organizationName + " does not contain any configured groups "));
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(" Organization " + organizationName + " does not contain any configured groups ")).build());
        }
        try {
            String response = Utils.getMapper().writeValueAsString((Object)new GroupsJaxbBean(groupNames));
            return response;
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get groups unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to generate JSON ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get groups unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to map JSON ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"get groups unsuccessful due to json parse error  ");
            throw new UMJSONParserException("IO Exception while parsing JSON ", (Throwable)e);
        }
    }

    @GET
    @Path(value="/groups")
    @Produces(value={"application/json"})
    public String listGroups(@Context HttpContext context) {
        return this.listGroups(null, context);
    }

    @DELETE
    @Path(value="/{groupName}/{organizationName:[^;/]*}")
    public Response deleteGroup(@PathParam(value="groupName") String groupName, @PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        boolean isDeleted;
        if (organizationName == "") {
            organizationName = this.cm.getLdapBase();
        }
        if (isDeleted = this.groupManager.deleteGroup(groupName, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd())) {
            this.logger.debug((Object)("Delete group successful: " + isDeleted));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)("Group " + groupName + " deleted successfully ")).build();
        }
        this.logger.error((Object)"Delete group unsuccessful ");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Group cannot be deleted  ").build();
    }

    @DELETE
    @Path(value="/groups/{organizationName}")
    public Response deleteAllGroups(@PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        boolean isDeleted = this.groupManager.deleteGroups(organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        if (isDeleted) {
            this.logger.debug((Object)("Delete groups successful: " + isDeleted));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Groups deleted successfully ").build();
        }
        this.logger.error((Object)"Delete groups unsuccessful ");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Groups for organization " + organizationName + " cannot be deleted  ")).build();
    }

    @DELETE
    @Path(value="/groups")
    public Response deleteAllGroups(@Context HttpContext context) {
        return this.deleteAllGroups(null, context);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response updateGroup(GroupJaxbBean groupBean, @Context HttpContext context) {
        this.logger.debug((Object)("Updating group " + groupBean.getGroupName() + " for oganization " + groupBean.getOrganizationName()));
        String organizationName = groupBean.getOrganizationName();
        GroupModel group = new GroupModel();
        group.setDescription(groupBean.getDescription());
        group.setGroupName(groupBean.getGroupName());
        if (this.groupManager.updateGroup(group, organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd())) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)("Group " + groupBean.getGroupName() + " successfully updated for organization " + organizationName)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("failed to update group " + groupBean.getGroupName() + " for organization " + organizationName)).build();
    }
}

