/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.um.rest.impl;

import it.eng.rdlab.soa3.um.rest.IUserManagementService;
import it.eng.rdlab.soa3.um.rest.bean.GroupModel;
import it.eng.rdlab.soa3.um.rest.utils.Utils;
import it.eng.rdlab.um.exceptions.GroupRetrievalException;
import it.eng.rdlab.um.exceptions.UserManagementSystemException;
import it.eng.rdlab.um.exceptions.UserRetrievalException;
import it.eng.rdlab.um.ldap.crossoperations.LdapUserGroupOperations;
import it.eng.rdlab.um.ldap.group.bean.LdapGroupModel;
import it.eng.rdlab.um.ldap.group.service.LdapGroupManager;
import it.eng.rdlab.um.ldap.user.bean.LdapUserModel;
import it.eng.rdlab.um.ldap.user.service.LdapUserManager;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class GroupManagerImpl
implements IUserManagementService.GroupManager {
    static Logger logger = Logger.getLogger((String)GroupManagerImpl.class.getName());
    private String ldapUrl = null;

    public GroupManagerImpl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public String createGroup(String groupName, String organizationName, String description, String adminUserId, String password) {
        logger.debug((Object)("Creating group: " + groupName));
        LdapGroupManager manager = null;
        String response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            LdapGroupModel groupModel = new LdapGroupModel();
            String dn = Utils.groupDNBuilder((String)groupName, (String)organizationName);
            groupModel.setGroupId(dn);
            groupModel.setGroupName(groupName);
            groupModel.setDescription(description);
            groupModel.addMemberDN("");
            response = manager.createGroup((it.eng.rdlab.um.group.beans.GroupModel)groupModel) ? dn : null;
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean deleteGroup(String groupName, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Deleting group: " + groupName));
        LdapGroupManager manager = null;
        boolean response = false;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            String dn = Utils.groupDNBuilder((String)groupName, (String)organizationName);
            response = manager.deleteGroup(dn, false);
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public List<GroupModel> listGroupsByOrganization(String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Listing all groups for organization " + organizationName));
        LdapGroupManager manager = null;
        ArrayList<GroupModel> response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            response = new ArrayList<GroupModel>();
            List modelList = manager.listGroups();
            for (it.eng.rdlab.um.group.beans.GroupModel currentGroup : modelList) {
                String groupDn = currentGroup.getGroupId();
                logger.debug((Object)("Generating group model for group " + groupDn));
                GroupModel group = new GroupModel();
                group.setGroupId(groupDn);
                group.setGroupName(currentGroup.getGroupName());
                group.setDescription(currentGroup.getDescription());
                logger.debug((Object)"Model generated");
                response.add(group);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public List<GroupModel> listGroupsByUser(String userId, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Getting all user groups for " + userId + " from: " + organizationName));
        LdapUserManager manager = null;
        ArrayList<GroupModel> groupList = new ArrayList<GroupModel>();
        List ldapGroup = new ArrayList();
        try {
            String organizationDn = Utils.organizationDNBuilder((String)organizationName);
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserManager(organizationDn);
            LdapUserModel user = (LdapUserModel)manager.getUser(Utils.userDNBuilder((String)userId, (String)organizationName));
            LdapUserGroupOperations userGroupManager = new LdapUserGroupOperations(manager, new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName)));
            ldapGroup = userGroupManager.listGroupsByUser(user.getFullname());
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
        }
        catch (UserManagementSystemException e) {
            logger.debug((Object)"System error ");
        }
        catch (UserRetrievalException e) {
            logger.debug((Object)"No users found");
        }
        catch (GroupRetrievalException e) {
            e.printStackTrace();
        }
        for (it.eng.rdlab.um.group.beans.GroupModel gm : ldapGroup) {
            GroupModel group = new GroupModel();
            group.setGroupId(gm.getGroupId());
            group.setGroupName(gm.getGroupName());
            group.setDescription(gm.getDescription());
            logger.debug((Object)"Group model created");
            groupList.add(group);
        }
        return groupList;
    }

    public boolean updateGroup(GroupModel group, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Updating group: " + group.getGroupName()));
        LdapGroupManager manager = null;
        boolean response = false;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            String dn = Utils.groupDNBuilder((String)group.getGroupName(), (String)organizationName);
            LdapGroupModel ldapGroupModel = new LdapGroupModel();
            ldapGroupModel.setDN(dn);
            ldapGroupModel.setGroupName(group.getGroupName());
            ldapGroupModel.setDescription(group.getDescription());
            response = manager.updateGroup((it.eng.rdlab.um.group.beans.GroupModel)ldapGroupModel);
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean updateGroupsOfOrganization(List<String> groupsNameList, String organizationName, String adminUserId, String password) {
        LdapGroupManager manager = null;
        String response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            String finalGroupName;
            List groups = manager.listGroups();
            ArrayList<String> groupNames = new ArrayList<String>();
            for (it.eng.rdlab.um.group.beans.GroupModel roleModel2 : groups) {
                finalGroupName = roleModel2.getGroupName();
                if (groupsNameList.contains(finalGroupName)) {
                    groupNames.add(finalGroupName);
                    continue;
                }
                boolean isDeleted = this.deleteGroup(finalGroupName, organizationName, adminUserId, password);
                if (isDeleted) continue;
                logger.error((Object)("An old group: " + finalGroupName + " is not deleted for organization " + organizationName));
            }
            LdapGroupModel ldapGroupModel = new LdapGroupModel();
            for (String groupName : groupsNameList) {
                String dn = Utils.groupDNBuilder((String)groupName, (String)organizationName);
                ldapGroupModel.setGroupId(dn);
                ldapGroupModel.setGroupName(groupName);
                if (!groupNames.contains(groupName)) {
                    logger.debug((Object)("Groupname does not exist already, hence creating one: " + groupName));
                    finalGroupName = manager.createGroup((it.eng.rdlab.um.group.beans.GroupModel)ldapGroupModel) ? dn : null;
                    if (finalGroupName != null) continue;
                    logger.debug((Object)"An error occourred during the operation");
                    return false;
                }
                logger.debug((Object)("Group already present, so leaving it as it is: " + groupName));
            }
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
            return false;
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return true;
    }

    public boolean deleteGroups(String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Removing all groups for organization " + organizationName));
        LdapGroupManager manager = null;
        boolean response = true;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            List modelList = manager.listGroups();
            for (it.eng.rdlab.um.group.beans.GroupModel group : modelList) {
                String groupDn = group.getGroupId();
                logger.debug((Object)("Deleting group model for group " + groupDn));
                boolean partialResponse = manager.deleteGroup(groupDn, false);
                logger.debug((Object)("Operation result " + partialResponse));
                response &= partialResponse;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean removeAllUsers(String groupName, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Removing all users from the group " + groupName));
        LdapGroupManager manager = null;
        boolean response = false;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            LdapGroupModel group = (LdapGroupModel)manager.getGroup(Utils.groupDNBuilder((String)groupName, (String)organizationName));
            group.getMemberDNS().clear();
            logger.debug((Object)"Updating LDAP");
            response = manager.updateGroup((it.eng.rdlab.um.group.beans.GroupModel)group);
            logger.debug((Object)"Update completed");
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public GroupModel getGroup(String groupName, String organizationName, String adminUserId, String password) {
        logger.debug((Object)("Getting the group " + groupName));
        LdapGroupManager manager = null;
        GroupModel response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            LdapGroupModel ldapGroupModel = (LdapGroupModel)manager.getGroup(Utils.groupDNBuilder((String)groupName, (String)organizationName));
            if (ldapGroupModel != null) {
                String groupDn = ldapGroupModel.getGroupId();
                logger.debug((Object)("Generating group model for group " + groupDn));
                response = new GroupModel();
                response.setGroupId(groupDn);
                response.setGroupName(ldapGroupModel.getGroupName());
                response.setDescription(ldapGroupModel.getDescription());
                logger.debug((Object)"Model generated");
            }
        }
        catch (Exception e) {
            logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        logger.debug((Object)("Operation completed with result " + response != null ? 1 : 0));
        return response;
    }
}

