/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.um.rest.impl;

import it.eng.rdlab.soa3.um.rest.IUserManagementService;
import it.eng.rdlab.soa3.um.rest.bean.GroupModel;
import it.eng.rdlab.soa3.um.rest.bean.RoleModel;
import it.eng.rdlab.soa3.um.rest.bean.UserModel;
import it.eng.rdlab.soa3.um.rest.conf.ConfigurationManager;
import it.eng.rdlab.soa3.um.rest.impl.OrganizationManagerImpl;
import it.eng.rdlab.soa3.um.rest.utils.Utils;
import it.eng.rdlab.um.ldap.crossoperations.LdapUserGroupOperations;
import it.eng.rdlab.um.ldap.crossoperations.LdapUserRoleOperations;
import it.eng.rdlab.um.ldap.group.bean.LdapGroupModel;
import it.eng.rdlab.um.ldap.group.service.LdapGroupManager;
import it.eng.rdlab.um.ldap.role.service.LdapRoleManager;
import it.eng.rdlab.um.ldap.user.bean.LdapUserModel;
import it.eng.rdlab.um.ldap.user.service.LdapUserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class UserManagerImpl
implements IUserManagementService.UserManager {
    private Logger logger = Logger.getLogger(this.getClass());
    private String ldapUrl = null;
    private IUserManagementService.OrganizationManager organizationManager;

    public UserManagerImpl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
        this.organizationManager = new OrganizationManagerImpl(ldapUrl);
    }

    public boolean assignRoleToUser(String roleName, String userId, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Assigning role " + roleName + " to user " + userId));
        LdapUserRoleOperations manager = null;
        boolean response = false;
        String organizationId = Utils.organizationDNBuilder((String)organizationName);
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserRoleOperations(new LdapUserManager(organizationId), new LdapRoleManager(organizationId));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            String userDn = Utils.userDNBuilder((String)userId, (String)organizationName);
            String roleDn = Utils.roleDNBuilder((String)roleName, (String)organizationName);
            this.logger.debug((Object)("User DN " + userDn));
            this.logger.debug((Object)("Role DN " + roleDn));
            response = manager.assignRoleToUser(roleDn, userDn);
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public String createUser(UserModel userModel, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Creating user: " + userModel.getUserId()));
        if (!this.organizationManager.existsOrganization(organizationName, adminUserId, password) && this.organizationManager.createOrganization(organizationName, adminUserId, password) == null) {
            this.logger.debug((Object)("Organization " + organizationName + " doesn't exists and unable to create it"));
            return null;
        }
        LdapUserManager manager = null;
        String response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            LdapUserModel user = new LdapUserModel();
            user.addObjectClass("organizationalPerson");
            String dn = Utils.userDNBuilder((String)userModel.getUserId(), (String)organizationName);
            user.setFullname(dn);
            user.setUserId(userModel.getUserId());
            user.setCN(userModel.getFirstname());
            user.setSN(userModel.getLastname());
            String userPassword = userModel.getPassword();
            if (userPassword != null) {
                user.setPassword(userPassword.toCharArray());
            }
            user.addExtraAttribute("mail", userModel.getEmail());
            if (userModel.getCertDN() != null) {
                user.addExtraAttribute("givenName", userModel.getCertDN());
            }
            response = manager.createUser((it.eng.rdlab.um.user.beans.UserModel)user) ? userModel.getUserId() : null;
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean deleteUser(String userId, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Deleting user: " + userId));
        LdapUserManager manager = null;
        boolean response = false;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            String userDn = Utils.userDNBuilder((String)userId, (String)organizationName);
            response = manager.deleteUser(userDn);
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public HashMap<UserModel, List<RoleModel>> listAllUsersAndRoles(String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Getting all users and roles from: " + organizationName));
        LdapUserManager manager = null;
        HashMap response = null;
        String organizationDn = Utils.organizationDNBuilder((String)organizationName);
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserManager(organizationDn);
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            manager = new LdapUserManager(organizationDn);
            List ldapUsers = manager.listUsers();
            LdapUserGroupOperations userGroupManager = new LdapUserGroupOperations(manager, new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName)));
            response = new HashMap();
            for (it.eng.rdlab.um.user.beans.UserModel ldapUser : ldapUsers) {
                LdapUserModel ldapUserModel = (LdapUserModel)ldapUser;
                this.logger.debug((Object)("Getting roles of the user " + ldapUser.getFullname()));
                UserModel model = Utils.convertUserModel((LdapUserModel)ldapUserModel);
                this.logger.debug((Object)"User model built");
                ArrayList<RoleModel> roleList = new ArrayList<RoleModel>();
                try {
                    List ldapGroup = userGroupManager.listGroupsByUser(ldapUserModel.getFullname());
                    for (it.eng.rdlab.um.group.beans.GroupModel gm : ldapGroup) {
                        RoleModel role = new RoleModel();
                        role.setRoleId(gm.getGroupId());
                        role.setRoleName(gm.getGroupName());
                        role.setDescription(gm.getDescription());
                        this.logger.debug((Object)"Role model created");
                        roleList.add(role);
                    }
                }
                catch (Exception e) {
                    this.logger.debug((Object)"No roles found");
                }
                response.put(model, roleList);
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)"Operation completed");
        return response;
    }

    public List<UserModel> listUsers(String adminUserId, String password) {
        return this.listUsersByOrganization("", adminUserId, password);
    }

    public List<UserModel> listUsersByRole(String roleName, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Listing all the users with role " + roleName));
        LdapUserRoleOperations manager = null;
        ArrayList<UserModel> response = null;
        String organizationDn = Utils.organizationDNBuilder((String)organizationName);
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserRoleOperations(new LdapUserManager(organizationDn), new LdapRoleManager(organizationDn));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            response = new ArrayList<UserModel>();
            String roleDn = Utils.roleDNBuilder((String)roleName, (String)organizationName);
            this.logger.debug((Object)("Role DN " + roleDn));
            List ldapUserModelList = manager.listUserByRole(roleDn);
            for (it.eng.rdlab.um.user.beans.UserModel um : ldapUserModelList) {
                LdapUserModel ldapUserModel = (LdapUserModel)um;
                this.logger.debug((Object)("Getting roles of the user " + ldapUserModel.getFullname()));
                UserModel model = Utils.convertUserModel((LdapUserModel)ldapUserModel);
                response.add(model);
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with an array of " + response.size() + " elements"));
        return response;
    }

    public List<UserModel> listUsersByOrganization(String organizationName, String adminUserId, String password) {
        return this.listUsersByOrganizationAndAttributes(organizationName, null, adminUserId, password);
    }

    public boolean updateUser(UserModel user, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Updating user: " + user.getUserId()));
        LdapUserManager manager = null;
        boolean response = false;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            LdapUserModel ldapUser = new LdapUserModel();
            ldapUser.addObjectClass("organizationalPerson");
            String dn = Utils.userDNBuilder((String)user.getUserId(), (String)organizationName);
            ldapUser.setFullname(dn);
            ldapUser.setUserId(user.getUserId());
            ldapUser.setCN(user.getFirstname());
            ldapUser.setSN(user.getLastname());
            String userPassword = user.getPassword();
            if (userPassword != null) {
                ldapUser.setPassword(userPassword.toCharArray());
            }
            ldapUser.addExtraAttribute("mail", user.getEmail());
            ldapUser.addExtraAttribute("givenName", user.getCertDN());
            response = manager.updateUser((it.eng.rdlab.um.user.beans.UserModel)ldapUser);
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public int changePassword(String userId, String oldPassword, String newPassword, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Changing password to user " + userId));
        int response = 0;
        if (newPassword == null) {
            this.logger.debug((Object)"new password null");
            response = 3;
        } else if (oldPassword == null) {
            this.logger.debug((Object)"The old password is null;");
            response = 1;
        } else if ((newPassword = newPassword.trim()).equals(oldPassword = oldPassword.trim())) {
            this.logger.debug((Object)"The two passwords are equal");
            response = 2;
        } else {
            try {
                Utils.initLdap((String)Utils.userDNBuilder((String)userId, (String)organizationName), (String)oldPassword, (String)this.ldapUrl);
            }
            catch (NamingException e) {
                response = 1;
                this.logger.debug((Object)"User password invalid..", (Throwable)e);
                return response;
            }
            this.logger.debug((Object)"Loading user...");
            UserModel currentModel = this.getUser(userId, organizationName, adminUserId, password);
            if (currentModel == null) {
                this.logger.debug((Object)"User not found");
                response = 4;
            } else {
                this.logger.debug((Object)"Start update operation...");
                currentModel.setPassword(newPassword);
                boolean updateRes = this.updateUser(currentModel, organizationName, adminUserId, password);
                this.logger.debug((Object)("Update operation result " + updateRes));
                response = updateRes ? 0 : 5;
            }
        }
        return response;
    }

    public boolean deleteUsers(String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Removing all users for organization " + organizationName));
        this.logger.debug((Object)"Removing users from roles");
        boolean clearRolesResult = this.clearUsersFromRoles(organizationName, adminUserId, password);
        this.logger.debug((Object)("Clear role operation result = " + clearRolesResult));
        LdapUserManager manager = null;
        boolean response = true;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            List users = manager.listUsers();
            for (it.eng.rdlab.um.user.beans.UserModel um : users) {
                String userDn = um.getFullname();
                this.logger.debug((Object)("Removing user " + userDn));
                boolean partialResponse = manager.deleteUser(userDn);
                this.logger.debug((Object)("Operation result " + partialResponse));
                response &= partialResponse;
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    private boolean clearUsersFromRoles(String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)"Clearing roles");
        LdapGroupManager manager = null;
        boolean response = true;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            List ldapGroupModelList = manager.listGroups();
            for (it.eng.rdlab.um.group.beans.GroupModel gm : ldapGroupModelList) {
                LdapGroupModel ldapGroupModel = (LdapGroupModel)gm;
                this.logger.debug((Object)("Deleting users from " + ldapGroupModel.getGroupId()));
                ldapGroupModel.getMemberDNS().clear();
                ldapGroupModel.addMemberDN(ConfigurationManager.getInstance().getLdapBase());
                boolean partialResponse = manager.updateGroup((it.eng.rdlab.um.group.beans.GroupModel)ldapGroupModel);
                this.logger.debug((Object)("Partial update operation result = " + partialResponse));
                response &= partialResponse;
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
            response = false;
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with response " + response));
        return response;
    }

    public UserModel getUser(String userId, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Get user " + userId));
        LdapUserManager manager = null;
        UserModel response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            LdapUserModel user = (LdapUserModel)manager.getUser(Utils.userDNBuilder((String)userId, (String)organizationName));
            if (user == null) {
                this.logger.debug((Object)"User Not found");
            } else {
                this.logger.debug((Object)"User Found");
                response = Utils.convertUserModel((LdapUserModel)user);
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        return response;
    }

    public boolean dismissRoleToUser(String roleName, String userId, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Dismissing role " + roleName + " from user " + userId));
        LdapUserRoleOperations manager = null;
        boolean response = false;
        String organizationId = Utils.organizationDNBuilder((String)organizationName);
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserRoleOperations(new LdapUserManager(organizationId), new LdapRoleManager(organizationId));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            String userDn = Utils.userDNBuilder((String)userId, (String)organizationName);
            String roleDn = Utils.roleDNBuilder((String)roleName, (String)organizationName);
            this.logger.debug((Object)("User DN " + userDn));
            this.logger.debug((Object)("Role DN " + roleDn));
            response = manager.dismissRoleFromUser(roleDn, userDn);
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean addUserToGroup(String userId, String groupId, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Adding user " + userId + " to group user " + groupId));
        LdapUserGroupOperations manager = null;
        boolean response = false;
        String organizationId = Utils.organizationDNBuilder((String)organizationName);
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserGroupOperations(new LdapUserManager(organizationId), new LdapGroupManager(organizationId));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            String userDn = Utils.userDNBuilder((String)userId, (String)organizationName);
            String groupDn = Utils.groupDNBuilder((String)groupId, (String)organizationName);
            this.logger.debug((Object)("User DN " + userDn));
            this.logger.debug((Object)("Group DN " + groupDn));
            response = manager.assignUserToGroup(userDn, groupDn);
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean removeUserFromGroup(String userId, String groupId, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Adding user " + userId + " to group user " + groupId));
        LdapUserGroupOperations manager = null;
        boolean response = false;
        String organizationId = Utils.organizationDNBuilder((String)organizationName);
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserGroupOperations(new LdapUserManager(organizationId), new LdapGroupManager(organizationId));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            String userDn = Utils.userDNBuilder((String)userId, (String)organizationName);
            String groupDn = Utils.groupDNBuilder((String)groupId, (String)organizationName);
            this.logger.debug((Object)("User DN " + userDn));
            this.logger.debug((Object)("Group DN " + groupDn));
            response = manager.dismissUserFromGroup(userDn, groupDn);
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public List<UserModel> listUsersByGroup(String groupName, String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Listing all the users in the group " + groupName));
        LdapUserGroupOperations manager = null;
        ArrayList<UserModel> response = null;
        String organizationDn = Utils.organizationDNBuilder((String)organizationName);
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserGroupOperations(new LdapUserManager(organizationDn), new LdapGroupManager(organizationDn));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            response = new ArrayList<UserModel>();
            String groupDN = Utils.groupDNBuilder((String)groupName, (String)organizationName);
            this.logger.debug((Object)("Group DN " + groupDN));
            List ldapUserModelList = manager.listUsersByGroup(groupDN);
            for (it.eng.rdlab.um.user.beans.UserModel um : ldapUserModelList) {
                LdapUserModel ldapUserModel = (LdapUserModel)um;
                this.logger.debug((Object)("Getting groups of the user " + ldapUserModel.getFullname()));
                UserModel model = Utils.convertUserModel((LdapUserModel)ldapUserModel);
                response.add(model);
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with an array of " + response.size() + " elements"));
        return response;
    }

    public HashMap<UserModel, List<GroupModel>> listAllUsersAndGroups(String organizationName, String adminUserId, String password) {
        this.logger.debug((Object)("Getting all users and groups from: " + organizationName));
        LdapUserManager manager = null;
        HashMap response = null;
        String organizationDn = Utils.organizationDNBuilder((String)organizationName);
        try {
            Utils.initLdap((String)adminUserId, (String)password, (String)this.ldapUrl);
            manager = new LdapUserManager(organizationDn);
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            manager = new LdapUserManager(organizationDn);
            List ldapUsers = manager.listUsers();
            LdapUserGroupOperations userGroupManager = new LdapUserGroupOperations(manager, new LdapGroupManager(Utils.organizationDNBuilder((String)organizationName)));
            response = new HashMap();
            for (it.eng.rdlab.um.user.beans.UserModel ldapUser : ldapUsers) {
                LdapUserModel ldapUserModel = (LdapUserModel)ldapUser;
                this.logger.debug((Object)("Getting groups of the user " + ldapUser.getFullname()));
                UserModel model = Utils.convertUserModel((LdapUserModel)ldapUserModel);
                this.logger.debug((Object)"User model built");
                ArrayList<GroupModel> groupList = new ArrayList<GroupModel>();
                try {
                    List ldapGroup = userGroupManager.listGroupsByUser(ldapUserModel.getFullname());
                    for (it.eng.rdlab.um.group.beans.GroupModel gm : ldapGroup) {
                        GroupModel group = new GroupModel();
                        group.setGroupId(gm.getGroupId());
                        group.setGroupName(gm.getGroupName());
                        group.setDescription(gm.getDescription());
                        this.logger.debug((Object)"Group model created");
                        groupList.add(group);
                    }
                }
                catch (Exception e) {
                    this.logger.debug((Object)"No roles found");
                }
                response.put(model, groupList);
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)"Operation completed");
        return response;
    }

    private List<it.eng.rdlab.um.user.beans.UserModel> internalListUsers(Map<String, String> attributes, LdapUserManager manager) throws Exception {
        this.logger.debug((Object)"Getting users");
        if (attributes == null) {
            this.logger.debug((Object)"No attributes set");
            return manager.listUsers();
        }
        LdapUserModel filter = new LdapUserModel();
        for (String key : attributes.keySet()) {
            String value = attributes.get(key);
            this.logger.debug((Object)("Adding attribute " + key + " " + value));
            filter.addExtraAttribute(key, value);
        }
        this.logger.debug((Object)"Listing values");
        return manager.listUsers((it.eng.rdlab.um.user.beans.UserModel)filter);
    }

    public List<UserModel> listUsersByOrganizationAndAttributes(String organizationName, Map<String, String> attributes, String adminUserId, String adminPassword) {
        this.logger.debug((Object)"Listing all the users");
        LdapUserManager manager = null;
        ArrayList<UserModel> response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)adminPassword, (String)this.ldapUrl);
            manager = new LdapUserManager(Utils.organizationDNBuilder((String)organizationName));
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            response = new ArrayList<UserModel>();
            List users = this.internalListUsers(attributes, manager);
            for (it.eng.rdlab.um.user.beans.UserModel um : users) {
                this.logger.debug((Object)"Generating user model");
                UserModel model = Utils.convertUserModel((LdapUserModel)((LdapUserModel)um));
                this.logger.debug((Object)"User model generated");
                response.add(model);
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        return response;
    }

    public List<UserModel> listUsersByAttribute(Map<String, String> attributes, String adminUserId, String adminPassword) {
        return this.listUsersByOrganizationAndAttributes("", attributes, adminUserId, adminPassword);
    }
}

