package it.eng.rdlab.soa3.authn.rest.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LoggerInstantiator {
	/**
	 * Logger initializer constructor
	 */
	static Logger logger = Logger.getLogger(LoggerInstantiator.class.getName());
	private static final String catalina_home = "catalina.home";
	private static Properties prop = new Properties();
//	 private static LoggerInstantiator instance = null;
	
	 public static LoggerInstantiator getInstance() {

	         return new LoggerInstantiator();

	   }

	protected LoggerInstantiator() {
		if(!prop.isEmpty()){
		//	PropertyConfigurator.configure(prop);
			return;
		}
		try {
			InputStream in;
			if (System.getProperty(catalina_home) != null) {
				logger.info("CATALINA.HOME system property defined. Will look in $CATALINA_HOME/conf for the log configuration file"
						+ " - logger_ips.properties ! "
						+ System.getProperty(catalina_home));
				File logFile = new File(System.getProperty(catalina_home)
						+ "/conf/ipsConfig/logger_ips.properties");
				if (!logFile.exists()) {
					in = getClass()
							.getResourceAsStream("logger_ips.properties");
				} else {
					in = new FileInputStream(logFile);
				}

			} else {
				in = getClass().getResourceAsStream("logger_ips.properties");
			}
			// Read the configuration from the file in the package
			
			prop.load(in);
			PropertyConfigurator.configure(prop);
			logger.info("Logger initialized. ");
		} catch (java.lang.NullPointerException ex) {
			System.out.println("Fatal Error at LoggerInstantiator: " + ex);
			System.exit(-1);
		} catch (IOException ex) {
			System.out.println("Fatal Error at LoggerInstantiator: " + ex);
			System.exit(-1);
		}
	}
}
