package it.eng.rdlab.soa3.authn.rest.impl;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.simple.SimpleLdapTemplate;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;


import it.eng.rdlab.soa3.authn.rest.AuthenticationContext;
import it.eng.rdlab.soa3.authn.rest.IAuthenticationService;
import it.eng.rdlab.soa3.authn.rest.util.Constants;

/**
 * Authentication service that authenticates users against LDAP
 * 
 * @author Kanchanna Ramasamy Balraj
 * @author Ermanno Travaglino
 * 
 */

public class AuthenticationServiceImpl implements IAuthenticationService 
{
	static Logger logger = Logger.getLogger(AuthenticationServiceImpl.class.getName());

	private SimpleLdapTemplate ldapTemplate;
	private AuthenticationContext authenticationContext;

	public AuthenticationServiceImpl() 
	{
		configureLdap();
	}

	public boolean authenticate(String userName, String password) 
	{

		logger.debug("Ldap configuration completed successfully..");

		AndFilter filter = new AndFilter();
		filter.and((new EqualsFilter("uid", userName)));
		logger.debug("contacting ldap with filter " + filter);
		return ldapTemplate.authenticate("", filter.toString(),password);

	}

	private void configureLdap() {

		Resource resource = new FileSystemResource (System.getProperty(Constants.CATALINA_HOME)
				+ "/conf/soa3/ldap.xml");

		if (!resource.exists()) 
		{
			logger.debug("loading default ldap config from filesystem");
			resource = new ClassPathResource(
					"it/rdlab/config/ldap.xml");
		}
		logger.debug("Using the config from file " + resource.getFilename());

		//		Resource resource = new FileSystemResource ("config/ldap.xml");
		//		
		//		if (!resource.exists()) 
		//		{
		//			logger.debug("loading default ldap config from filesystem");
		//			resource = new ClassPathResource(
		//				"config/ldap.xml");
		//		}
		//		logger.debug("Using the config from file " + resource.getFilename());
		BeanFactory factory = new XmlBeanFactory(resource);
		AuthenticationContext authenticationContext = (AuthenticationContext) factory.getBean("authenticationContext");


		this.ldapTemplate = authenticationContext.getLdapTemplate();
		logger.debug(" configured context source and ldap template..");
		this.authenticationContext = authenticationContext;

	}

	@Override
	public boolean isUserAuthenticated(String userName,String password) {
		return authenticate(userName, password);

	}

	@Override
	public AuthenticationContext getAuthenticationContext() 
	{

		return this.authenticationContext;
	}



	//	public void setLdapTemplate(SimpleLdapTemplate ldapTemplate) {
	//		this.ldapTemplate = ldapTemplate;
	//	}

	//	public static void main(String[] args) {
	//		boolean isauthenticated = new AuthenticationServiceImpl()
	//				.isUserAuthenticated("test","test");
	//		System.out.println(isauthenticated);
	//	}



}
