/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.impl;

import it.eng.rdlab.soa3.connector.utils.SoapUtils;
import it.eng.rdlab.soa3.pm.connector.beans.Status;
import it.eng.rdlab.soa3.pm.connector.impl.PolicyGetUtils;
import it.eng.rdlab.soa3.pm.connector.interfaces.PolicyDeleter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PolicyDeleterImpl
implements PolicyDeleter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String url;

    public PolicyDeleterImpl() {
    }

    public PolicyDeleterImpl(String url) {
        this();
        this.setUrl(url);
    }

    public void setUrl(String url) {
        this.url = url + "/";
    }

    @Override
    public Status clear() {
        try {
            String url = this.url + "HighLevelPolicyManagementService";
            this.logger.debug("Url = " + url);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document requestDocument = builder.newDocument();
            Element root = requestDocument.createElementNS("http://services.pap.authz.glite.org", "eraseRepository");
            this.logger.debug("Creating alias element...");
            requestDocument.appendChild(root);
            SOAPMessage message = null;
            try {
                this.logger.debug("Generating soap message");
                message = SoapUtils.generateSoapMessage((Document)requestDocument);
                this.logger.debug("Soap Message generated");
            }
            catch (Exception se) {
                this.logger.error("Unable to generate soap message", (Throwable)se);
                return new Status(2, 1);
            }
            SOAPMessage response = null;
            try {
                this.logger.debug("Sending message");
                response = SoapUtils.performCall((SOAPMessage)message, (String)url);
                this.logger.debug("Soap Message generated");
                this.logger.debug(SoapUtils.soapMessage2String((SOAPMessage)response));
                SOAPBody responseBody = response.getSOAPBody();
                NodeList nodeList = responseBody.getElementsByTagName("eraseRepository");
                if (nodeList.getLength() > 0) {
                    return new Status(0, 0);
                }
                this.logger.debug("Response false");
                return new Status(0, 1);
            }
            catch (Exception ge) {
                ge.printStackTrace();
                this.logger.error("Error in sending the message", (Throwable)ge);
                return new Status(1, 1);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            this.logger.error("Unable to create the request", (Throwable)e);
            return new Status(2, 1);
        }
    }

    @Override
    public Status deletePolicy(String alias, String policyId) {
        return this.deleteElement(alias, policyId, "removePolicy", "policyId", "removePolicyReturn");
    }

    private boolean parseResponse(SOAPMessage response, String tagResponse) throws Exception {
        this.logger.debug("Parsing response message...");
        this.logger.debug("Response message " + SoapUtils.soapMessage2String((SOAPMessage)response));
        SOAPBody responseBody = response.getSOAPBody();
        NodeList nodeList = responseBody.getElementsByTagNameNS("http://services.pap.authz.glite.org", tagResponse);
        if (nodeList.getLength() > 0) {
            String info = ((Element)nodeList.item(0)).getTextContent();
            this.logger.debug("Text response = " + info);
            return info != null && info.equalsIgnoreCase("true");
        }
        return false;
    }

    @Override
    public Status deletePolicySet(String alias, String policySetId) {
        return this.deleteElement(alias, policySetId, "removePolicySet", "policySetId", "removePolicySetReturn");
    }

    private Status deleteElement(String alias, String elementId, String operationTag, String elementTag, String responseTag) {
        SOAPMessage soapResponse = null;
        try {
            String url = this.url + "XACMLPolicyManagementService";
            soapResponse = PolicyGetUtils.identifyElement(url, alias, elementId, operationTag, elementTag);
            if (soapResponse == null) {
                this.logger.error("Server error");
                return new Status(1, 1);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to generate soap message", (Throwable)e);
            return new Status(2, 1);
        }
        try {
            if (this.parseResponse(soapResponse, responseTag)) {
                return new Status(0, 0);
            }
            return new Status(0, 1);
        }
        catch (Exception e) {
            this.logger.error("Invalid response received", (Throwable)e);
            return new Status(1, 1);
        }
    }

    @Override
    public Status deleteRule(String alias, String ruleId) {
        return this.deleteElement(alias, ruleId, "removeObjectByIdAndReferences", "id", "removeObjectByIdAndReferencesReturn");
    }
}

