/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.javaapi.impl.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeLoader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Properties properties = new Properties();
    public String DEFAULT_ATTRIBUTE_FILE = "/it/eng/rdlab/soa3/pm/connector/service/resources/attributes.properties";
    private Map<String, String> valueKeyMap = new HashMap<String, String>();
    private static AttributeLoader instance;

    public static AttributeLoader getInstance() {
        if (instance == null) {
            instance = new AttributeLoader();
        }
        return instance;
    }

    private AttributeLoader() {
        try {
            this.properties.load(this.getClass().getResourceAsStream(this.DEFAULT_ATTRIBUTE_FILE));
        }
        catch (IOException e) {
            this.logger.error("Unable to load the attributes file", (Throwable)e);
        }
    }

    public String getAttribute(String id) {
        String value = this.properties.getProperty(id, id);
        this.logger.debug("ID = " + id + " value " + value);
        if (!this.valueKeyMap.containsKey(value)) {
            this.valueKeyMap.put(value, id);
        }
        return value;
    }

    public String getAttributeId(String value) {
        String id = this.valueKeyMap.get(value);
        if (id == null) {
            id = this.findId(value);
            this.valueKeyMap.put(value, id);
        }
        return id;
    }

    private String findId(String value) {
        String response = null;
        Iterator<Map.Entry<Object, Object>> entries = this.properties.entrySet().iterator();
        while (entries.hasNext() && response == null) {
            Map.Entry<Object, Object> entry = entries.next();
            String entryValue = (String)entry.getValue();
            this.logger.debug("Value found " + entryValue);
            if (entryValue.equals(value)) {
                response = (String)entry.getKey();
                this.logger.debug("Key found " + response);
                continue;
            }
            this.logger.debug("Key not found");
        }
        if (response == null) {
            response = value;
        }
        this.logger.debug("Response = " + response);
        return response;
    }
}

