/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.service;

import it.eng.rdlab.um.ldap.LdapBasicConstants;
import it.eng.rdlab.um.ldap.LdapDataModelWrapper;
import it.eng.rdlab.um.ldap.configuration.LdapConfiguration;
import it.eng.rdlab.um.ldap.service.LdapDataModelComparator;
import it.eng.rdlab.um.ldap.service.LdapGenericDataModelComparator;
import it.eng.rdlab.um.ldap.service.exceptions.LdapManagerException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.ConfigurationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapManager
implements LdapBasicConstants {
    private Log log = LogFactory.getLog(this.getClass());
    private DirContext dirContext;
    private static LdapManager instance;
    private boolean isClose = true;

    private LdapManager(LdapConfiguration configuration) throws NamingException {
        this.log.debug((Object)"Initializing LDAP manager...");
        String userDn = configuration.getUserDn();
        String password = configuration.getPassword();
        String url = configuration.getUrl();
        this.log.debug((Object)("Ldap URL = " + url));
        this.log.debug((Object)("User DN = " + userDn));
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        this.log.debug((Object)userDn);
        if (userDn != null) {
            env.put("java.naming.security.principal", userDn);
        }
        if (password != null) {
            env.put("java.naming.security.credentials", password);
        }
        this.dirContext = new InitialDirContext(env);
        this.isClose = false;
        this.log.debug((Object)"LDAP manager initialized");
    }

    public static LdapManager initInstance(LdapConfiguration configuration) throws NamingException {
        instance = new LdapManager(configuration);
        return instance;
    }

    public static LdapManager getInstance() throws ConfigurationException {
        if (instance == null) {
            throw new ConfigurationException("No Ldap Manager istance configured, use initInstance!!!");
        }
        return instance;
    }

    public boolean createDataElement(LdapDataModelWrapper dataModelWrapper) throws LdapManagerException {
        this.log.debug((Object)"Loading object classes");
        if (!dataModelWrapper.validateData()) {
            this.log.error((Object)"Invalid data");
            throw new LdapManagerException("Invalid data");
        }
        Attribute objectClassAttributes = this.loadObjectClassAttribute(dataModelWrapper);
        BasicAttributes attributeContainer = new BasicAttributes();
        attributeContainer.put(objectClassAttributes);
        Map<String, String> modelAttributes = dataModelWrapper.getAttributeMap();
        Map<String, List<String>> modelListAttributes = dataModelWrapper.getListAttributeMap();
        for (String key : modelAttributes.keySet()) {
            String value = modelAttributes.get(key);
            this.log.debug((Object)("Attribute key = " + key));
            this.log.debug((Object)("Attribute value = " + value));
            attributeContainer.put(new BasicAttribute(key, value));
        }
        for (String key : modelListAttributes.keySet()) {
            List<String> value = modelListAttributes.get(key);
            this.log.debug((Object)("Attribute key = " + key));
            BasicAttribute basicAttribute = new BasicAttribute(key);
            for (String singleValue : value) {
                this.log.debug((Object)("Attribute value = " + singleValue));
                basicAttribute.add(singleValue);
            }
            attributeContainer.put(basicAttribute);
        }
        String dn = dataModelWrapper.getDistinguishedName();
        this.log.debug((Object)("Attributes generated, creating the data element " + dn));
        try {
            this.dirContext.createSubcontext(dn, (Attributes)attributeContainer);
            return true;
        }
        catch (NamingException e) {
            this.log.error((Object)"Unable to create the new user", (Throwable)e);
            throw new LdapManagerException("Unable to create the new data element", e);
        }
    }

    public boolean deleteData(String dn) throws LdapManagerException {
        try {
            this.dirContext.destroySubcontext(dn);
            return true;
        }
        catch (NamingException e) {
            this.log.error((Object)"Unable to complete the operation", (Throwable)e);
            throw new LdapManagerException("Unable to complete the operation", e);
        }
    }

    public Attributes getData(String dn) throws LdapManagerException {
        this.log.debug((Object)("Getting data with dn " + dn));
        try {
            Attributes result = this.dirContext.getAttributes(dn);
            this.log.debug((Object)"Data found");
            return result;
        }
        catch (NamingException e) {
            throw new LdapManagerException("Unable to get data", e);
        }
    }

    public NamingEnumeration<SearchResult> searchData(LdapDataModelWrapper filter) throws LdapManagerException {
        this.log.debug((Object)"Searching data");
        String filterString = this.buildFilter(filter);
        this.log.debug((Object)("with filter " + filterString));
        String dn = filter.getDistinguishedName();
        this.log.debug((Object)("Base DN = " + dn));
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        try {
            NamingEnumeration<SearchResult> answer = this.dirContext.search(dn, filterString, ctls);
            this.log.debug((Object)"Operation completed");
            return answer;
        }
        catch (NamingException e) {
            this.log.error((Object)"Unable to complete the operation", (Throwable)e);
            throw new LdapManagerException("Unable to complete the search", e);
        }
    }

    public boolean updateData(LdapDataModelWrapper oldData, LdapDataModelWrapper newData) throws NamingException {
        return this.updateData(oldData, newData, new LdapGenericDataModelComparator());
    }

    public boolean updateData(LdapDataModelWrapper oldData, LdapDataModelWrapper newData, LdapDataModelComparator comparator) throws NamingException {
        this.log.debug((Object)"Comparing and updating datas");
        List<ModificationItem> modificationItems = comparator.compare(oldData, newData);
        if (modificationItems.size() > 0) {
            this.log.debug((Object)"Performing the modifications");
            this.dirContext.modifyAttributes(oldData.getDistinguishedName(), modificationItems.toArray(new ModificationItem[modificationItems.size()]));
            this.log.debug((Object)"Modifications completed");
            return true;
        }
        this.log.debug((Object)"The attributes are equal, no modifications requider");
        return false;
    }

    private Attribute loadObjectClassAttribute(LdapDataModelWrapper dataModelWrapper) {
        this.log.debug((Object)"Loading object class attributes");
        List objectClasses = (List)dataModelWrapper.getObjectParameter("OBJECTCLASSES");
        BasicAttribute objectClassAttributes = new BasicAttribute("objectClass");
        for (String oc : objectClasses) {
            this.log.debug((Object)("Object class Attribute " + oc));
            objectClassAttributes.add(oc);
        }
        this.log.debug((Object)"Object class attributes loaded");
        return objectClassAttributes;
    }

    private String buildFilter(LdapDataModelWrapper filter) {
        Object attributeValue;
        this.log.debug((Object)"building filter");
        StringBuilder builder = new StringBuilder("(&");
        List<String> objectClasses = filter.getObjectClasses();
        Map<String, String> attributes = filter.getAttributeMap();
        Map<String, List<String>> listAttributes = filter.getListAttributeMap();
        if (objectClasses != null) {
            for (String objectClassParameter : objectClasses) {
                this.log.debug((Object)("Filter for object class parameter " + objectClassParameter));
                builder.append("(").append("objectClass").append("=").append(objectClassParameter).append(")");
            }
        }
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.log.debug((Object)("Filter for parameter " + key));
                attributeValue = attributes.get(key);
                this.log.debug((Object)("value " + (String)attributeValue));
                if (((String)attributeValue).trim().length() > 0) {
                    builder.append("(").append(key).append("=").append((String)attributeValue).append(")");
                    continue;
                }
                this.log.debug((Object)("attribute value " + (String)attributeValue + " not valid"));
            }
        }
        if (listAttributes != null) {
            for (String key : listAttributes.keySet()) {
                this.log.debug((Object)("Filter for parameter " + key));
                attributeValue = listAttributes.get(key);
                Iterator iterator = attributeValue.iterator();
                while (iterator.hasNext()) {
                    String singleValue = (String)iterator.next();
                    this.log.debug((Object)("value " + singleValue));
                    builder.append("(").append(key).append("=").append(singleValue).append(")");
                }
            }
        }
        builder.append(")");
        return builder.toString();
    }

    public void close() throws NamingException {
        if (!this.isClose) {
            this.dirContext.close();
        }
        this.isClose = true;
    }
}

