/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.crossoperations;

import it.eng.rdlab.um.crossoperations.UserRoleOperations;
import it.eng.rdlab.um.exceptions.RoleRetrievalException;
import it.eng.rdlab.um.exceptions.UserManagementSystemException;
import it.eng.rdlab.um.exceptions.UserRetrievalException;
import it.eng.rdlab.um.ldap.role.bean.LdapRoleModel;
import it.eng.rdlab.um.ldap.role.service.LdapRoleManager;
import it.eng.rdlab.um.ldap.user.bean.LdapUserModel;
import it.eng.rdlab.um.ldap.user.service.LdapUserManager;
import it.eng.rdlab.um.role.beans.RoleModel;
import it.eng.rdlab.um.user.beans.UserModel;
import java.util.ArrayList;
import java.util.List;
import javax.naming.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapUserRoleOperations
implements UserRoleOperations {
    private Log log;
    private LdapUserManager userManager;
    private LdapRoleManager roleManager;

    public LdapUserRoleOperations(LdapUserManager userManager, LdapRoleManager roleManager) throws ConfigurationException {
        if (userManager == null || roleManager == null) {
            throw new ConfigurationException("At least one of the default managers is null");
        }
        this.userManager = userManager;
        this.roleManager = roleManager;
        this.log = LogFactory.getLog(this.getClass());
    }

    public List<RoleModel> listRolesByUser(String userId) throws UserManagementSystemException, RoleRetrievalException, UserRetrievalException {
        this.log.debug((Object)("Listing all roles that contains the user " + userId));
        LdapRoleModel filter = new LdapRoleModel();
        filter.addRoleOccupantDN(userId);
        List<RoleModel> roleModels = this.roleManager.listRoles(filter);
        this.log.debug((Object)("response size = " + roleModels.size()));
        return roleModels;
    }

    public void close() {
        this.userManager.close();
        this.roleManager.close();
    }

    public boolean assignRoleToUser(String roleId, String userId) throws UserManagementSystemException, UserRetrievalException, RoleRetrievalException {
        this.log.debug((Object)"Assign role to user");
        this.log.debug((Object)"Forcing to find the user in order to verify if exists");
        LdapUserModel userModel = (LdapUserModel)this.userManager.getUser(userId);
        this.log.debug((Object)"User exists");
        LdapRoleModel roleModel = (LdapRoleModel)this.roleManager.getRole(roleId);
        if (roleModel == null) {
            this.log.error((Object)("Role " + roleId + " not found"));
            throw new RoleRetrievalException("Role " + roleId + " not found");
        }
        if (userModel == null) {
            this.log.error((Object)("User " + userId + " not found"));
            throw new UserRetrievalException("User " + userId + " not found");
        }
        roleModel.addRoleOccupantDN(userId);
        this.roleManager.updateRole(roleModel);
        return true;
    }

    public List<UserModel> listUserByRole(String roleId) throws UserManagementSystemException, UserRetrievalException, RoleRetrievalException {
        this.log.debug((Object)("Listing all the users contained in the role " + roleId));
        LdapRoleModel roleModel = (LdapRoleModel)this.roleManager.getRole(roleId);
        List<String> userIds = roleModel.getRoleOccupantDNS();
        ArrayList<UserModel> response = new ArrayList<UserModel>();
        for (String dn : userIds) {
            this.log.debug((Object)("Getting user with DN " + dn));
            try {
                UserModel userModel = this.userManager.getUser(dn);
                if (userModel == null) {
                    this.log.error((Object)("User with dn " + dn + " not found!"));
                    continue;
                }
                response.add(userModel);
            }
            catch (Exception e) {
                this.log.warn((Object)("User " + dn + " not found"));
            }
        }
        this.log.debug((Object)("Response size = " + response.size()));
        return response;
    }

    public boolean dismissRoleFromUser(String roleId, String userId) throws UserManagementSystemException, UserRetrievalException, RoleRetrievalException {
        this.log.debug((Object)"Removing user from role");
        LdapRoleModel roleModel = (LdapRoleModel)this.roleManager.getRole(roleId);
        boolean response = false;
        if (roleModel.getRoleOccupantDNS().remove(userId)) {
            response = this.roleManager.updateRole(roleModel);
        } else {
            this.log.warn((Object)("Element " + userId + " not found"));
            response = true;
        }
        this.log.debug((Object)("Operation complete with response " + response));
        return response;
    }
}

