/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.user.service;

import it.eng.rdlab.um.exceptions.UserManagementSystemException;
import it.eng.rdlab.um.exceptions.UserRetrievalException;
import it.eng.rdlab.um.ldap.LdapBasicConstants;
import it.eng.rdlab.um.ldap.service.LdapManager;
import it.eng.rdlab.um.ldap.service.exceptions.LdapManagerException;
import it.eng.rdlab.um.ldap.user.bean.LdapUserModel;
import it.eng.rdlab.um.ldap.user.bean.LdapUserModelWrapper;
import it.eng.rdlab.um.ldap.user.service.LdapUserDataModelComparator;
import it.eng.rdlab.um.ldap.user.service.LdapUserModelGenerator;
import it.eng.rdlab.um.user.beans.UserModel;
import it.eng.rdlab.um.user.service.UserManager;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapUserManager
implements UserManager,
LdapBasicConstants {
    private Log log = LogFactory.getLog(this.getClass());
    private LdapManager ldapManager = LdapManager.getInstance();
    private String baseDn;

    public LdapUserManager(String baseDn) throws NamingException {
        this.baseDn = baseDn != null ? baseDn : "";
    }

    public boolean createUser(UserModel usermodel) throws UserManagementSystemException {
        this.log.debug((Object)("Creating user with dn " + usermodel.getFullname()));
        LdapUserModelWrapper dataModelWrapper = new LdapUserModelWrapper(usermodel);
        try {
            return this.ldapManager.createDataElement(dataModelWrapper);
        }
        catch (LdapManagerException e) {
            throw new UserManagementSystemException("unable to create the user", (Exception)e);
        }
    }

    public UserModel getUser(String userId) throws UserManagementSystemException, UserRetrievalException {
        this.log.debug((Object)("Getting user with dn " + userId));
        try {
            Attributes attributes = this.ldapManager.getData(userId);
            if (attributes == null) {
                this.log.debug((Object)"No results found");
                return null;
            }
            return LdapUserModelGenerator.generate(userId, attributes, true);
        }
        catch (LdapManagerException e) {
            this.log.error((Object)"Unable to contact the Ldap server", (Throwable)e);
            throw new UserRetrievalException("Unable to contact the Ldap server", (Exception)e);
        }
        catch (NamingException e) {
            this.log.error((Object)"Generic LDAP error", (Throwable)e);
            throw new UserManagementSystemException("Unable to contact the Ldap server", (Exception)e);
        }
    }

    public boolean deleteUser(String userId) throws UserManagementSystemException, UserRetrievalException {
        this.log.debug((Object)("Deleting user with dn " + userId));
        try {
            boolean response = this.ldapManager.deleteData(userId);
            this.log.debug((Object)"Operation completed with result ");
            return response;
        }
        catch (LdapManagerException e) {
            this.log.error((Object)"Unable to complete the operation", (Throwable)e);
            throw new UserRetrievalException("Unable to complete the operation", (Exception)e);
        }
    }

    public boolean updateUser(UserModel user) throws UserManagementSystemException, UserRetrievalException {
        this.log.debug((Object)"Updating user");
        String userId = user.getFullname();
        UserModel oldModel = this.getUser(userId);
        if (oldModel == null) {
            this.log.error((Object)"No user found");
            return false;
        }
        this.log.debug((Object)"Performing update operation...");
        boolean response = false;
        try {
            response = this.ldapManager.updateData(new LdapUserModelWrapper(oldModel), new LdapUserModelWrapper(user), new LdapUserDataModelComparator());
            this.log.debug((Object)("Operation completed with response " + response));
            return true;
        }
        catch (NamingException e) {
            this.log.error((Object)"Operation not completed", (Throwable)e);
            throw new UserManagementSystemException("Operation not completed", (Exception)e);
        }
    }

    public List<UserModel> listUsers() throws UserManagementSystemException, UserRetrievalException {
        this.log.debug((Object)"Generic search");
        LdapUserModel dummyFilter = new LdapUserModel();
        dummyFilter.setFullname(this.baseDn);
        return this.listUsers(dummyFilter);
    }

    public List<UserModel> listUsers(UserModel filter) throws UserManagementSystemException, UserRetrievalException {
        this.log.debug((Object)"Filtered search");
        if (filter.getFullname() == null || filter.getFullname().length() == 0) {
            filter.setFullname(this.baseDn);
        }
        try {
            NamingEnumeration<SearchResult> answer = this.ldapManager.searchData(new LdapUserModelWrapper(filter));
            ArrayList<UserModel> response = new ArrayList<UserModel>();
            while (answer.hasMoreElements()) {
                SearchResult a = (SearchResult)answer.nextElement();
                Attributes attributes = a.getAttributes();
                LdapUserModel um = LdapUserModelGenerator.generate(a.getNameInNamespace(), attributes, true);
                response.add(um);
            }
            return response;
        }
        catch (LdapManagerException e) {
            this.log.error((Object)"Unable to complete the search ", (Throwable)e);
            throw new UserRetrievalException("Unable to complete the search ", (Exception)e);
        }
        catch (NamingException e) {
            this.log.error((Object)"Unable to generate the results ", (Throwable)e);
            throw new UserManagementSystemException("Unable to complete the search ", (Exception)e);
        }
    }

    public void close() {
        try {
            this.ldapManager.close();
        }
        catch (NamingException e) {
            this.log.error((Object)"Unable to close the connection ", (Throwable)e);
        }
    }
}

