/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.role.bean;

import it.eng.rdlab.um.beans.GenericModel;
import it.eng.rdlab.um.beans.GenericModelWrapper;
import it.eng.rdlab.um.ldap.LdapAbstractModelWrapper;
import it.eng.rdlab.um.ldap.validators.LdapRoleValidator;
import it.eng.rdlab.um.role.beans.RoleModel;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapRoleModelWrapper
extends LdapAbstractModelWrapper {
    private Log log = LogFactory.getLog(this.getClass());
    private List<String> roleOccupantList;

    public LdapRoleModelWrapper(RoleModel roleModel) {
        super((GenericModel)roleModel);
        this.initModel(roleModel);
    }

    private void initModel(RoleModel roleModel) {
        this.log.debug((Object)"Loading uid");
        if (roleModel.getRoleName() != null && roleModel.getRoleName().length() > 0) {
            this.attributeMap.put("cn", roleModel.getRoleName());
        }
        if (roleModel.getDescription() != null && roleModel.getDescription().length() > 0) {
            this.attributeMap.put("description", roleModel.getDescription());
        }
        this.log.debug((Object)"Loading dn");
        this.dn = roleModel.getRoleId();
        this.roleOccupantList = (List)new GenericModelWrapper((GenericModel)roleModel).getObjectParameter("roleOccupant");
    }

    @Override
    public boolean validateData() {
        return LdapRoleValidator.validate(this.dn, this.objectClasses, this.attributeMap, this.roleOccupantList);
    }
}

