/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.group.service;

import it.eng.rdlab.um.ldap.LdapModelGenerator;
import it.eng.rdlab.um.ldap.group.bean.LdapOrganizationModel;
import it.eng.rdlab.um.ldap.group.bean.LdapOrganizationModelWrapper;
import it.eng.rdlab.um.ldap.service.exceptions.LdapManagerException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapOrganizationModelGenerator
implements LdapModelGenerator {
    private Log log = LogFactory.getLog(this.getClass());

    public LdapOrganizationModel generate(String dn, Attributes attributes, boolean validate) throws NamingException, LdapManagerException {
        this.log.debug((Object)"Creating new organization Model");
        LdapOrganizationModel response = new LdapOrganizationModel();
        response.setOrganizationDN(dn);
        NamingEnumeration<? extends Attribute> resultAttributes = attributes.getAll();
        while (resultAttributes.hasMore()) {
            String value;
            Attribute attribute = resultAttributes.next();
            String attributeId = attribute.getID();
            this.log.debug((Object)("Attribute id = " + attributeId));
            NamingEnumeration<?> values = attribute.getAll();
            if (attributeId.equals("objectClass")) {
                this.log.debug((Object)"Generating class object list");
                while (values.hasMore()) {
                    value = (String)values.next();
                    this.log.debug((Object)("Found value " + value));
                    response.addObjectClass(value);
                }
                continue;
            }
            if (attributeId.equals("o")) {
                response.setOrganizationName(values.next().toString());
                continue;
            }
            this.log.debug((Object)"Updating attribute map...");
            if (!values.hasMore()) continue;
            value = values.next();
            this.log.debug((Object)("Found value " + value));
            if (value instanceof String) {
                response.addExtraAttribute(attributeId, value);
                continue;
            }
            this.log.warn((Object)("Not string value found in " + attributeId));
        }
        if (validate) {
            this.log.debug((Object)"Validate result...");
            if (!new LdapOrganizationModelWrapper(response).validateData()) {
                throw new LdapManagerException("Received not valid data");
            }
        }
        this.log.debug((Object)"Model generated");
        return response;
    }
}

