/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.group.bean;

import it.eng.rdlab.um.group.beans.GroupModel;
import it.eng.rdlab.um.ldap.LdapModelConstants;
import java.util.ArrayList;
import java.util.List;

public class LdapGroupModel
extends GroupModel
implements LdapModelConstants {
    public static final String OBJECT_CLASS_GROUP = "groupOfNames";
    public static final String MEMBERS_DN = "member";
    public static final String GROUP_CN = "cn";
    public static final String DESCRIPTION = "description";
    public static final String ROLE = "businessCategory";

    public LdapGroupModel() {
        ArrayList<String> objectClasses = new ArrayList<String>();
        objectClasses.add("top");
        objectClasses.add(OBJECT_CLASS_GROUP);
        super.addObject("OBJECTCLASSES", objectClasses);
        super.addObject(MEMBERS_DN, new ArrayList());
        this.setId("");
    }

    public LdapGroupModel(GroupModel groupModel) {
        super(groupModel);
    }

    public LdapGroupModel(String groupDN, String groupCN, String description, List<String> objectClasses) {
        super(groupDN, "", groupCN, description);
        if (objectClasses == null) {
            objectClasses = new ArrayList<String>();
            objectClasses.add("top");
            objectClasses.add(OBJECT_CLASS_GROUP);
            super.addObject("OBJECTCLASSES", objectClasses);
        } else {
            if (!objectClasses.contains("top")) {
                objectClasses.add("top");
            }
            if (!objectClasses.contains(OBJECT_CLASS_GROUP)) {
                this.addObjectClass(OBJECT_CLASS_GROUP);
            }
        }
        if (groupDN == null) {
            this.setId("");
        }
        if (groupCN == null) {
            this.setGroupName("");
        }
        super.addObject(MEMBERS_DN, new ArrayList());
    }

    public void setDN(String groupDN) {
        super.setId(groupDN);
    }

    public String getDN() {
        return this.getId();
    }

    public static String getRole() {
        return ROLE;
    }

    public void setRole(String role) {
        super.addObject(ROLE, (Object)role);
    }

    public List<String> getObjectClasses() {
        return (List)super.getObject("OBJECTCLASSES");
    }

    public void addObjectClass(String objectClassName) {
        ((List)super.getObject("OBJECTCLASSES")).add(objectClassName);
    }

    public void addMemberDN(String memberDn) {
        ((List)super.getObject(MEMBERS_DN)).add(memberDn);
    }

    public List<String> getMemberDNS() {
        return (List)super.getObject(MEMBERS_DN);
    }

    public void addExtraAttribute(String name, String value) {
        super.addObject(name, (Object)value);
    }
}

