package org.gcube.security.soa3.connector.credentials;

import org.gcube.soa3.connector.common.security.Credentials;
import org.gcube.soa3.connector.common.security.MessageConstants;
import org.w3c.dom.Element;

public class TicketCredentials implements Credentials
{
	private Element element;
	private String 	type,
					binaryTokenValue;
	
	public static final String SES = "SES";
			
	
	public TicketCredentials(Element element) 
	{
		this.element = element;
	}
	
	public TicketCredentials (String ticket)
	{
		this.binaryTokenValue = ticket;
	}

	@Override
	public void prepareCredentials() 
	{
		if (element != null)
		{
			this.type = this.element.getAttribute(MessageConstants.ENCODING_TYPE_LABEL);
			this.binaryTokenValue = this.element.getAttribute(MessageConstants.ID_LABEL);
		}
		else this.type = SES;
	}

	@Override
	public String getAuthenticationType() 
	{
		return this.type;
	}

	@Override
	public String getAuthenticationString() 
	{
		return binaryTokenValue;
	}

	@Override
	public String getHeaderString() 
	{
		return this.type + " "+this.getAuthenticationString(); 
	}
	

}
