/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.service.jaxrs;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.core.HttpContext;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.RuleBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.engine.PolicyDecisionEngine;
import it.eng.rdlab.soa3.pm.connector.service.factory.PolicyDecisionEngineFactory;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/policyquery")
public class PolicyDecisionService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PolicyDecisionEngine engine = PolicyDecisionEngineFactory.getPolicyDecisionEngine();

    public PolicyDecisionService() {
        if (this.engine == null) {
            this.logger.error("Unable to create a policy decision engine");
        }
    }

    @GET
    @Path(value="/{role}/{action}/{resource}")
    public Response getDecision(@PathParam(value="role") String role, @PathParam(value="action") String action, @PathParam(value="resource") String resource, @Context HttpContext context) {
        this.logger.debug("Get decision");
        if (this.engine != null) {
            this.logger.debug("Asking Policy Decision Engine");
            RuleBean bean = new RuleBean();
            bean.getAttributes().add("urn:oasis:names:tc:xacml:2.0:subject:role=" + role);
            bean.setAction(action);
            bean.setResource(resource);
            return this.executeQuery(bean);
        }
        this.logger.error("Internal server error");
        return Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)"Service not available").build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response getDecision(RuleBean ruleBean) {
        this.logger.debug("Get decision");
        if (this.engine != null) {
            this.logger.debug("Asking Policy Decision Engine");
            return this.executeQuery(ruleBean);
        }
        this.logger.error("Internal server error");
        return Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)"Service not available").build();
    }

    private Response executeQuery(RuleBean ruleBean) {
        if (this.engine.getDecision(ruleBean)) {
            this.logger.debug("Authorization grant!");
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)"Authorized").build();
        }
        this.logger.debug("Not authorized");
        return Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)"Not Authorized").build();
    }
}

