package it.eng.rdlab.soa3.pm.connector.service.jaxrs;

import it.eng.rdlab.soa3.pm.connector.javaapi.beans.RuleBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.engine.PolicyDecisionEngine;
import it.eng.rdlab.soa3.pm.connector.service.factory.PolicyDecisionEngineFactory;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sun.jersey.api.core.HttpContext;

@Path("/policyquery")
public class PolicyDecisionService 
{
	private Logger logger;
	private PolicyDecisionEngine engine;
	
	public PolicyDecisionService() 
	{
		this.logger = LoggerFactory.getLogger(this.getClass());
		this.engine = PolicyDecisionEngineFactory.getPolicyDecisionEngine();
		
		if (this.engine == null) logger.error("Unable to create a policy decision engine");
		
	}

	/**
	 * 
	 * Simple query for a default role
	 * 
	 * @param role
	 * @param action
	 * @param resource
	 * @param context
	 * @return
	 */
	@GET
	@Path("/{role}/{action}/{resource}")
	public Response getDecision (@PathParam("role") String role, @PathParam("action")  String action,@PathParam("resource")  String resource, @Context HttpContext context)
	{
		logger.debug("Get decision");
	
		if (this.engine != null)
		{
			logger.debug("Asking Policy Decision Engine");
			RuleBean bean = new RuleBean();
			bean.getAttributes().add(PolicyDecisionEngine.ROLE_DEFAULT_ATTRIBUTE+"="+role);
			bean.setAction(action);
			bean.setResource(resource);
			return executeQuery(bean);

		}
		else
		{
			logger.error("Internal server error");
			return Response.status(com.sun.jersey.api.client.ClientResponse.Status.INTERNAL_SERVER_ERROR).entity("Service not available").build();
		}
		
	}
	
	/**
	 * 
	 * POST based query with complex datasent
	 * 
	 * @param ruleBean
	 * @return
	 */
	@POST
	@Consumes (MediaType.APPLICATION_JSON)
	public Response getDecision (RuleBean ruleBean)
	{
		logger.debug("Get decision");
		
		if (this.engine != null)
		{
			logger.debug("Asking Policy Decision Engine");
			return executeQuery(ruleBean);

		}
		else
		{
			logger.error("Internal server error");
			return Response.status(com.sun.jersey.api.client.ClientResponse.Status.INTERNAL_SERVER_ERROR).entity("Service not available").build();
		}
	}
	
	
	
	private Response executeQuery (RuleBean ruleBean)
	{
		if (this.engine.getDecision(ruleBean))
		{
			logger.debug("Authorization grant!");
			return Response.status(com.sun.jersey.api.client.ClientResponse.Status.OK).entity("Authorized").build();
		}
		else
		{
			logger.debug("Not authorized");
			return Response.status(com.sun.jersey.api.client.ClientResponse.Status.UNAUTHORIZED).entity("Not Authorized").build();
		}
	}
}
