/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.service.jaxrs;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.util.Base64;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.Attribute;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.ResponseBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.RuleBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.engine.PolicyEngine;
import it.eng.rdlab.soa3.pm.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.pm.connector.service.factory.PolicyEngineFactory;
import it.eng.rdlab.soa3.pm.connector.service.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/policymanager")
public class PolicyManagerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PolicyEngine engine;

    public PolicyManagerService() {
        Configuration.init();
        this.engine = PolicyEngineFactory.getPolicyEngine();
        this.logger.debug("Policy engine generated");
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createRule(RuleBean ruleBean, @Context HttpContext context) {
        this.logger.debug("Calling the policy creation engine...");
        ResponseBean response = this.engine.createRule(ruleBean);
        this.logger.debug("Response received " + response);
        switch (response.getStatus()) {
            case -2: {
                return Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Rule not created ").build();
            }
            case -1: {
                return Response.status((Response.StatusType)ClientResponse.Status.CONFLICT).entity((Object)response.getInfo()).build();
            }
        }
        return Response.status((Response.StatusType)ClientResponse.Status.CREATED).entity((Object)response.getInfo()).build();
    }

    @GET
    @Path(value="/{ruleId}")
    public Response getRule(@PathParam(value="ruleId") String ruleId, @Context HttpContext context) {
        this.logger.debug("Calling the policy reading engine...");
        this.logger.debug("Rule ID " + ruleId);
        RuleBean ruleBean = this.engine.getRule(ruleId);
        this.logger.debug("Response received");
        if (ruleBean != null) {
            String value = null;
            try {
                value = Utils.getMapper().writeValueAsString((Object)ruleBean);
                this.logger.debug("Policy response " + value);
                return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)value).build();
            }
            catch (JsonGenerationException e) {
                this.logger.error("get user unsuccessful due to json parse error  ");
                value = "json parser error";
            }
            catch (JsonMappingException e) {
                this.logger.error("get user unsuccessful due to json parse error  ");
                value = "json mapping error";
            }
            catch (IOException e) {
                this.logger.error("get user unsuccessful due to json parse error  ");
                value = "json parser error";
            }
            throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)value).build());
        }
        this.logger.debug("Policy not found");
        return Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)"Policy not found").build();
    }

    @PUT
    @Path(value="/{ruleId}")
    public Response updateRule(@PathParam(value="ruleId") String ruleId, RuleBean ruleBean, @Context HttpContext context) {
        this.logger.debug("Calling the policy updating engine...");
        this.logger.debug("Rule ID " + ruleBean);
        ResponseBean response = this.engine.updateRule(ruleId, ruleBean);
        this.logger.debug("Response received " + response.getStatus());
        switch (response.getStatus()) {
            case -3: {
                return Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)"Policy not updated: the policy is not present ").build();
            }
            case -2: {
                return Response.status((Response.StatusType)ClientResponse.Status.NOT_MODIFIED).entity((Object)"Policy not updated: unable to modify the policy").build();
            }
            case -1: {
                return Response.status((Response.StatusType)ClientResponse.Status.CONFLICT).entity((Object)response.getInfo()).build();
            }
        }
        return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)response.getInfo()).build();
    }

    @DELETE
    @Path(value="/{ruleId}")
    public Response deletePolicy(@PathParam(value="ruleId") String ruleId, @Context HttpContext context) {
        this.logger.debug("Calling the policy deletion engine...");
        boolean response = this.engine.deleteRule(ruleId);
        this.logger.debug("Response received " + response);
        if (response) {
            this.logger.debug("Policy deleted");
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)"Policy has been deleted successfully ").build();
        }
        this.logger.debug("Policy not deleted");
        return Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Policy not deleted ").build();
    }

    @GET
    @Path(value="/{subjects}")
    public Response listPoliciesBySubjects(@PathParam(value="subjects") String subjects, @Context HttpContext context) {
        this.logger.debug("Calling the rule retrieving engine...");
        this.logger.debug("Subject attributes " + subjects);
        List attributesList = this.getAttributes(subjects);
        List policyBeans = this.engine.listRulesBySubjects(attributesList);
        this.logger.debug("Policy beans retrieved");
        String value = null;
        try {
            value = Utils.getMapper().writeValueAsString((Object)policyBeans);
            this.logger.debug("Policy response " + value);
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)value).build();
        }
        catch (JsonGenerationException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        catch (JsonMappingException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json mapping error";
        }
        catch (IOException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)value).build());
    }

    private List<Attribute> getAttributes(String subjects) {
        this.logger.debug("Generating subjects map");
        ArrayList<Attribute> response = new ArrayList<Attribute>();
        if (subjects != null) {
            String[] keyValues;
            String decodedSubjects = new String(Base64.decode((String)subjects));
            this.logger.debug("Decoded subjects = " + decodedSubjects);
            for (String keyvalue : keyValues = decodedSubjects.split(":")) {
                this.logger.debug("KeyValue " + keyvalue);
                String[] kv = keyvalue.split("=");
                try {
                    response.add(new Attribute(kv[0].trim(), kv[1].trim()));
                }
                catch (RuntimeException e) {
                    this.logger.error("Unable to add a value in the attribute table", (Throwable)e);
                }
            }
        } else {
            this.logger.debug("No attributes found");
        }
        return response;
    }

    @GET
    @Path(value="/{action}")
    public Response listPoliciesByAction(@PathParam(value="action") String action, @Context HttpContext context) {
        this.logger.debug("Calling the policy retrieving engine...");
        this.logger.debug("Action " + action);
        List policyBeans = this.engine.listRulesByAction(action);
        this.logger.debug("Policy beans retrieved");
        String value = null;
        try {
            value = Utils.getMapper().writeValueAsString((Object)policyBeans);
            this.logger.debug("Policy response " + value);
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)value).build();
        }
        catch (JsonGenerationException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        catch (JsonMappingException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json mapping error";
        }
        catch (IOException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)value).build());
    }

    @GET
    @Path(value="/{respurce}")
    public Response listPoliciesByResource(@PathParam(value="respurce") String respurce, @Context HttpContext context) {
        this.logger.debug("Calling the policy retrieving engine...");
        this.logger.debug("Resource " + respurce);
        List policyBeans = this.engine.listRulesByResource(respurce);
        this.logger.debug("Policy beans retrieved");
        String value = null;
        try {
            value = Utils.getMapper().writeValueAsString((Object)policyBeans);
            this.logger.debug("Policy response " + value);
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)value).build();
        }
        catch (JsonGenerationException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        catch (JsonMappingException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json mapping error";
        }
        catch (IOException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)value).build());
    }
}

