/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.service.configuration;

import it.eng.rdlab.soa3.pm.connector.javaapi.configuration.ConfigurationManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManagerRestImpl
implements ConfigurationManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Properties properties;

    protected ConfigurationManagerRestImpl() {
        Properties files = this.getConfigurationFiles();
        String root = files.getProperty("CONFIGURATION_ROOT", "");
        String path = files.getProperty("CONFIGURATION_FILE", "");
        if (root != null && root.startsWith("$")) {
            root = System.getProperty(root.substring(1));
            this.logger.debug("Actual root " + root);
        }
        path = root + path;
        this.logger.debug("Configuration path = " + path);
        this.properties = new Properties();
        try {
            this.properties.load(new FileInputStream(path));
        }
        catch (Exception e) {
            this.logger.warn("Configuration file not found", (Throwable)e);
            this.logger.warn("Using default values");
            try {
                this.properties.load(this.getClass().getResourceAsStream("/it/eng/rdlab/soa3/um/rest/conf/configuration.properties"));
            }
            catch (IOException e1) {
                this.logger.error("Unable to find properties from the classpath", (Throwable)e);
            }
        }
    }

    private Properties getConfigurationFiles() {
        Properties fileProperties = new Properties();
        try {
            fileProperties.load(this.getClass().getResourceAsStream("/it/eng/rdlab/soa3/pm/connector/service/resources/configurationfiles.properties"));
        }
        catch (IOException e1) {
            this.logger.error("Unable to find properties from the classpath", (Throwable)e1);
        }
        return fileProperties;
    }

    public String getPolicyManagerUrl() {
        return this.properties.getProperty("POLICY_REPOSITORY_URL", "http://localhost:8568");
    }
}

