package it.eng.rdlab.soa3.pm.connector.service.configuration;

import it.eng.rdlab.soa3.pm.connector.javaapi.configuration.ConfigurationManager;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * 
 * Configuration Manager for rest service
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class ConfigurationManagerRestImpl implements ConfigurationManager
{
	
	private Logger logger;
	private Properties properties;
	
	protected ConfigurationManagerRestImpl ()
	{
		this.logger = LoggerFactory.getLogger(this.getClass());
		Properties files = getConfigurationFiles();
		String root = files.getProperty(ConfigurationConstants.CONFIGURATION_ROOT,"");
		String path = files.getProperty(ConfigurationConstants.CONFIGURATION_FILE,"");
		
		if (root != null && root.startsWith("$"))
		{
			root = System.getProperty(root.substring(1));
			logger.debug("Actual root "+root);
		}
	
		path = root+path;
		logger.debug("Configuration path = "+path);
		
		this.properties = new Properties();
		try {
			this.properties.load(new FileInputStream(path));
		} catch (Exception e) 
		{
			this.logger.warn("Configuration file not found",e);
			this.logger.warn("Using default values");
			
			try {
				this.properties.load(this.getClass().getResourceAsStream(ConfigurationConstants.DEFAULT_PROP_FILE));
			} catch (IOException e1) 
			{
				this.logger.error("Unable to find properties from the classpath",e);
			}

		} 
	}
	
	private Properties getConfigurationFiles ()
	{
		Properties fileProperties = new Properties();
		try 
		{
			fileProperties.load(this.getClass().getResourceAsStream(ConfigurationConstants.CONFIGURATION_RES_FILE));
		} catch (IOException e1) 
		{
			this.logger.error("Unable to find properties from the classpath",e1);
			
		}
		
		return fileProperties;
	}
	
	
	/**
	 * 
	 * @return
	 */
	public String getPolicyManagerUrl ()
	{
		return this.properties.getProperty(ConfigurationConstants.POLICY_REPOSITORY_URL,ConfigurationConstants.POLICY_REPOSITORY_DEFAULT_URL);
	}

}
